/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.javaunit.autoparams.ArgumentsGenerator;
import org.javaunit.autoparams.AutoSource;
import org.javaunit.autoparams.BuilderGenerator;
import org.javaunit.autoparams.Repeat;
import org.javaunit.autoparams.generator.CompositeObjectGenerator;
import org.javaunit.autoparams.generator.ObjectGenerationContext;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.util.AnnotationUtils;

final class AutoArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<AutoSource> {
    private final ObjectGenerator generator;
    private int repeat;

    private AutoArgumentsProvider(ObjectGenerator generator) {
        this.generator = generator;
        this.repeat = 1;
    }

    public AutoArgumentsProvider() {
        this(new CompositeObjectGenerator(ObjectGenerator.DEFAULT, new BuilderGenerator()));
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        ArgumentsGenerator generator = this.createArgumentsGenerator(context);
        return generator.generateArguments(context);
    }

    private ArgumentsGenerator createArgumentsGenerator(ExtensionContext context) {
        int repeat = this.getRepeat(context);
        return new ArgumentsGenerator(new ObjectGenerationContext(context, this.generator), repeat);
    }

    private int getRepeat(ExtensionContext context) {
        Method method = context.getRequiredTestMethod();
        return AnnotationUtils.findAnnotation((AnnotatedElement)method, Repeat.class).map(Repeat::value).orElse(this.repeat);
    }

    public void accept(AutoSource annotation) {
        this.repeat = annotation.repeat();
    }
}

