/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.javaunit.autoparams.customization.AnnotationVisitor;
import org.javaunit.autoparams.customization.ArgumentProcessing;
import org.javaunit.autoparams.customization.ArgumentProcessor;
import org.javaunit.autoparams.customization.Customizer;
import org.junit.jupiter.api.extension.ExtensionContext;

final class Customizers {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{new Object()});

    Customizers() {
    }

    static void addCustomizer(ExtensionContext context, Customizer customizer) {
        Customizers.getStore(context).add(customizer);
    }

    static Stream<Customizer> getCustomizers(ExtensionContext context) {
        return Customizers.getStore(context).stream();
    }

    private static List<Customizer> getStore(ExtensionContext context) {
        return (List)context.getStore(NAMESPACE).getOrComputeIfAbsent(Customizers.class, k -> new ArrayList(), List.class);
    }

    static Stream<Customizer> processArgument(Parameter parameter, Object argument) {
        return Arrays.stream(parameter.getAnnotations()).flatMap(annotation -> Arrays.stream(annotation.annotationType().getAnnotationsByType(ArgumentProcessing.class)).map(ArgumentProcessing::value).map(Customizers::createProcessor).map(processor -> Customizers.visitAnnotation(processor, annotation))).map(processor -> processor.process(parameter, argument));
    }

    private static <T extends ArgumentProcessor> T createProcessor(Class<? extends T> type) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (T)((ArgumentProcessor)constructor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static <T extends Annotation> ArgumentProcessor visitAnnotation(ArgumentProcessor processor, T annotation) {
        if (processor instanceof AnnotationVisitor) {
            ((AnnotationVisitor)((Object)processor)).visit(annotation);
        }
        return processor;
    }
}

