/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams;

import java.lang.annotation.Annotation;
import java.util.stream.Stream;
import org.javaunit.autoparams.ArgumentsAssembler;
import org.javaunit.autoparams.ArgumentsProviderCreator;
import org.javaunit.autoparams.AutoArgumentsProvider;
import org.javaunit.autoparams.EnumAutoSource;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.support.AnnotationConsumer;

class EnumAutoArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<EnumAutoSource> {
    private final ArgumentsProvider enumProvider = ArgumentsProviderCreator.createProvider(EnumSource.class);
    private final AutoArgumentsProvider autoProvider = new AutoArgumentsProvider();

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        return ArgumentsAssembler.assembleArguments(context, this.enumProvider, this.autoProvider);
    }

    public void accept(EnumAutoSource annotation) {
        ((AnnotationConsumer)this.enumProvider).accept((Object)this.createDelegate(annotation));
    }

    private EnumSource createDelegate(final EnumAutoSource source) {
        return new EnumSource(){

            public Class<? extends Annotation> annotationType() {
                return EnumSource.class;
            }

            public Class<? extends Enum<?>> value() {
                return source.value();
            }

            public String[] names() {
                return source.names();
            }

            public EnumSource.Mode mode() {
                return source.mode();
            }
        };
    }
}

