/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.customization;

import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import org.javaunit.autoparams.customization.AnnotationVisitor;
import org.javaunit.autoparams.customization.ArgumentProcessor;
import org.javaunit.autoparams.customization.Customizer;
import org.javaunit.autoparams.customization.Fix;
import org.javaunit.autoparams.generator.ObjectContainer;

final class ArgumentFixer
implements ArgumentProcessor,
AnnotationVisitor<Fix> {
    private boolean byExactType = false;
    private boolean byImplementedInterfaces = false;

    ArgumentFixer() {
    }

    @Override
    public Customizer process(Parameter parameter, Object argument) {
        ArrayList<Function<Type, Boolean>> predicates = new ArrayList<Function<Type, Boolean>>();
        if (this.byExactType) {
            predicates.add(type -> type.equals(parameter.getType()));
        }
        if (this.byImplementedInterfaces) {
            Class[] interfaces = parameter.getType().getInterfaces();
            predicates.add(type -> Arrays.stream(interfaces).anyMatch(type::equals));
        }
        return generator -> (query, context) -> predicates.stream().anyMatch(predicate -> (Boolean)predicate.apply(query.getType())) ? new ObjectContainer(argument) : generator.generate(query, context);
    }

    @Override
    public void visit(Fix annotation) {
        this.byExactType = annotation.byExactType();
        this.byImplementedInterfaces = annotation.byImplementedInterfaces();
    }
}

