/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.customization;

import java.lang.reflect.Type;
import java.util.Stack;
import org.javaunit.autoparams.customization.Customizer;
import org.javaunit.autoparams.generator.ObjectContainer;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class RecursionGuard
implements Customizer {
    public static final int DEFAULT_RECURSION_DEPTH = 1;
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{RecursionGuard.class});
    private static final Object CONTEXT_KEY = RecursionGuard.class;
    private final int recursionDepth;

    public RecursionGuard(int recursionDepth) {
        this.recursionDepth = recursionDepth;
    }

    public RecursionGuard() {
        this(1);
    }

    @Override
    public ObjectGenerator customize(ObjectGenerator generator) {
        return (query, context) -> {
            Object scope = new Object();
            ExtensionContext.Store store = context.getExtensionContext().getStore(NAMESPACE);
            RecursionContext recursionContext = (RecursionContext)store.getOrComputeIfAbsent(CONTEXT_KEY, x -> new RecursionContext(scope), RecursionContext.class);
            try {
                ObjectContainer objectContainer;
                if (!recursionContext.guard.equals(this)) {
                    ObjectContainer objectContainer2 = generator.generate(query, context);
                    return objectContainer2;
                }
                Stack<Type> monitor = recursionContext.monitor;
                Type type = query.getType();
                monitor.push(type);
                try {
                    long depth = monitor.stream().filter(x -> x.equals(type)).count();
                    objectContainer = depth > (long)this.recursionDepth ? new ObjectContainer(null) : generator.generate(query, context);
                    monitor.pop();
                }
                catch (Throwable throwable) {
                    monitor.pop();
                    throw throwable;
                }
                return objectContainer;
            }
            finally {
                if (recursionContext.scope.equals(scope)) {
                    store.remove(CONTEXT_KEY);
                }
            }
        };
    }

    private class RecursionContext {
        public final Stack<Type> monitor = new Stack();
        public final RecursionGuard guard;
        public final Object scope;

        public RecursionContext(Object scope) {
            this.guard = RecursionGuard.this;
            this.scope = scope;
        }
    }
}

