/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.customization;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class RuntimeTypeResolver {
    private Map<TypeVariable<?>, Type> map;

    private RuntimeTypeResolver(Map<TypeVariable<?>, Type> map) {
        this.map = map;
    }

    public static RuntimeTypeResolver create(Type source) {
        return new RuntimeTypeResolver(source instanceof ParameterizedType ? RuntimeTypeResolver.buildMap((ParameterizedType)source) : Collections.emptyMap());
    }

    public static Map<TypeVariable<?>, Type> buildMap(ParameterizedType parameterizedType) {
        Class rawType = (Class)parameterizedType.getRawType();
        TypeVariable<Class<T>>[] typeVariables = rawType.getTypeParameters();
        Type[] typeValues = parameterizedType.getActualTypeArguments();
        HashMap map = new HashMap();
        for (int i = 0; i < typeVariables.length; ++i) {
            map.put(typeVariables[i], typeValues[i]);
        }
        return map;
    }

    public Type resolve(Type type) {
        if (this.map.containsKey(type)) {
            return this.map.get(type);
        }
        if (type instanceof ParameterizedType) {
            return this.resolve((ParameterizedType)type);
        }
        return type;
    }

    private Type resolve(final ParameterizedType parameterizedType) {
        final Type[] typeArguments = parameterizedType.getActualTypeArguments();
        for (int i = 0; i < typeArguments.length; ++i) {
            typeArguments[i] = this.resolve(typeArguments[i]);
        }
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return (Type[])typeArguments.clone();
            }

            @Override
            public Type getRawType() {
                return RuntimeTypeResolver.this.resolve(parameterizedType.getRawType());
            }

            @Override
            public Type getOwnerType() {
                return RuntimeTypeResolver.this.resolve(parameterizedType.getOwnerType());
            }
        };
    }
}

