/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.generator;

import java.lang.reflect.Type;
import java.util.concurrent.ThreadLocalRandom;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.javaunit.autoparams.generator.ArgumentQuery;
import org.javaunit.autoparams.generator.ObjectContainer;
import org.javaunit.autoparams.generator.ObjectGenerationContext;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.javaunit.autoparams.generator.ObjectQuery;

final class ByteGenerator
implements ObjectGenerator {
    ByteGenerator() {
    }

    @Override
    public ObjectContainer generate(ObjectQuery query, ObjectGenerationContext context) {
        Type type = query.getType();
        return type == Byte.TYPE || type == Byte.class ? new ObjectContainer(this.factory(this.getMin(query), this.getMax(query))) : ObjectContainer.EMPTY;
    }

    private byte getMin(ObjectQuery query) {
        return query instanceof ArgumentQuery ? this.getMin((ArgumentQuery)query) : (byte)-128;
    }

    private byte getMin(ArgumentQuery query) {
        Min min = query.getParameter().getAnnotation(Min.class);
        if (min == null) {
            return -128;
        }
        if (min.value() < -128L) {
            throw new IllegalArgumentException("The min constraint underflowed.");
        }
        if (min.value() > 127L) {
            throw new IllegalArgumentException("The min constraint overflowed.");
        }
        return (byte)min.value();
    }

    private byte getMax(ObjectQuery query) {
        return query instanceof ArgumentQuery ? this.getMax((ArgumentQuery)query) : (byte)127;
    }

    private byte getMax(ArgumentQuery query) {
        Max max = query.getParameter().getAnnotation(Max.class);
        if (max == null) {
            return 127;
        }
        if (max.value() < -128L) {
            throw new IllegalArgumentException("The max constraint underflowed.");
        }
        if (max.value() > 127L) {
            throw new IllegalArgumentException("The max constraint overflowed.");
        }
        return (byte)max.value();
    }

    private byte factory(byte min, byte max) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (min == -128 && max == 127) {
            return (byte)random.nextInt(-128, 127);
        }
        int offset = max == 127 ? -1 : 0;
        int origin = min + offset;
        int bound = max + 1 + offset;
        return (byte)(random.nextInt(origin, bound) - offset);
    }
}

