/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.generator;

import java.lang.reflect.Type;
import java.util.concurrent.ThreadLocalRandom;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.javaunit.autoparams.generator.ArgumentQuery;
import org.javaunit.autoparams.generator.ObjectContainer;
import org.javaunit.autoparams.generator.ObjectGenerationContext;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.javaunit.autoparams.generator.ObjectQuery;

final class IntegerGenerator
implements ObjectGenerator {
    IntegerGenerator() {
    }

    @Override
    public ObjectContainer generate(ObjectQuery query, ObjectGenerationContext context) {
        Type type = query.getType();
        return type == Integer.TYPE || type == Integer.class ? new ObjectContainer(this.factory(this.getMin(query), this.getMax(query))) : ObjectContainer.EMPTY;
    }

    private int getMin(ObjectQuery query) {
        return query instanceof ArgumentQuery ? this.getMin((ArgumentQuery)query) : Integer.MIN_VALUE;
    }

    private int getMin(ArgumentQuery query) {
        Min annotation = query.getParameter().getAnnotation(Min.class);
        return annotation == null ? Integer.MIN_VALUE : (int)Math.min(Math.max(annotation.value(), Integer.MIN_VALUE), Integer.MAX_VALUE);
    }

    private int getMax(ObjectQuery query) {
        return query instanceof ArgumentQuery ? this.getMax((ArgumentQuery)query) : Integer.MAX_VALUE;
    }

    private int getMax(ArgumentQuery query) {
        Max annotation = query.getParameter().getAnnotation(Max.class);
        return annotation == null ? Integer.MAX_VALUE : (int)Math.max(Math.min(annotation.value(), Integer.MAX_VALUE), Integer.MIN_VALUE);
    }

    private int factory(int min, int max) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (min == Integer.MIN_VALUE && max == Integer.MAX_VALUE) {
            return random.nextInt();
        }
        int offset = max == Integer.MAX_VALUE ? -1 : 0;
        int origin = min + offset;
        int bound = max + 1 + offset;
        return random.nextInt(origin, bound) - offset;
    }
}

