/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.generator;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.javaunit.autoparams.generator.ObjectContainer;
import org.javaunit.autoparams.generator.ObjectGenerationContext;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.javaunit.autoparams.generator.ObjectQuery;

final class MapGenerator
implements ObjectGenerator {
    private static final int SIZE = 3;

    MapGenerator() {
    }

    @Override
    public ObjectContainer generate(ObjectQuery query, ObjectGenerationContext context) {
        return query.getType() instanceof ParameterizedType ? this.generate((ParameterizedType)query.getType(), context) : ObjectContainer.EMPTY;
    }

    private ObjectContainer generate(ParameterizedType type, ObjectGenerationContext context) {
        return this.isMap((Class)type.getRawType()) ? new ObjectContainer(this.factory(type.getActualTypeArguments()[0], type.getActualTypeArguments()[1], context)) : ObjectContainer.EMPTY;
    }

    private boolean isMap(Class<?> type) {
        return type.equals(HashMap.class) || type.equals(Map.class) || type.equals(AbstractMap.class);
    }

    private <K, V> HashMap<K, V> factory(Type keyType, Type valueType, ObjectGenerationContext context) {
        HashMap<Object, Object> instance = new HashMap<Object, Object>();
        ObjectQuery keyQuery = () -> keyType;
        ObjectQuery valueQuery = () -> valueType;
        for (int i = 0; i < 3; ++i) {
            instance.put(context.generate(keyQuery), context.generate(valueQuery));
        }
        return instance;
    }
}

