/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.generator;

import java.lang.reflect.Type;
import org.javaunit.autoparams.customization.Customizer;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.javaunit.autoparams.generator.ObjectQuery;
import org.javaunit.autoparams.generator.UnwrapFailedException;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class ObjectGenerationContext {
    private final ExtensionContext extensionContext;
    private ObjectGenerator generator;

    public ObjectGenerationContext(ExtensionContext extensionContext, ObjectGenerator generator) {
        this.extensionContext = extensionContext;
        this.generator = generator;
    }

    public ExtensionContext getExtensionContext() {
        return this.extensionContext;
    }

    public <T> T generate(Class<T> type) {
        return (T)this.generate(() -> type);
    }

    public Object generate(ObjectQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("The argument 'query' is null.");
        }
        Type type = query.getType();
        if (ExtensionContext.class.equals((Object)type)) {
            return this.extensionContext;
        }
        if (ObjectGenerator.class.equals((Object)type)) {
            return this.generator;
        }
        return this.generateObject(query);
    }

    private Object generateObject(ObjectQuery query) {
        try {
            return this.generator.generate(query, this).unwrapOrElseThrow();
        }
        catch (UnwrapFailedException exception) {
            throw this.composeGenerationFailedException(query, exception);
        }
    }

    private RuntimeException composeGenerationFailedException(ObjectQuery query, Throwable cause) {
        String messageFormat = "Object cannot be created with the given query '%s'. This can happen if the query represents an interface or abstract class.";
        String message = String.format(messageFormat, query);
        return new RuntimeException(message, cause);
    }

    public void customizeGenerator(Customizer customizer) {
        if (customizer == null) {
            throw new IllegalArgumentException("The argument 'customizer' is null.");
        }
        this.generator = customizer.customize(this.generator);
    }
}

