/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.generator;

import java.lang.reflect.Type;
import java.util.concurrent.ThreadLocalRandom;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.javaunit.autoparams.generator.ArgumentQuery;
import org.javaunit.autoparams.generator.ObjectContainer;
import org.javaunit.autoparams.generator.ObjectGenerationContext;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.javaunit.autoparams.generator.ObjectQuery;

final class ShortGenerator
implements ObjectGenerator {
    ShortGenerator() {
    }

    @Override
    public ObjectContainer generate(ObjectQuery query, ObjectGenerationContext context) {
        Type type = query.getType();
        return type == Short.TYPE || type == Short.class ? new ObjectContainer(this.factory(this.getMin(query), this.getMax(query))) : ObjectContainer.EMPTY;
    }

    private short getMin(ObjectQuery query) {
        return query instanceof ArgumentQuery ? this.getMin((ArgumentQuery)query) : (short)Short.MIN_VALUE;
    }

    private short getMin(ArgumentQuery query) {
        Min annotation = query.getParameter().getAnnotation(Min.class);
        return annotation == null ? (short)Short.MIN_VALUE : this.convertToShort(annotation.value());
    }

    private short getMax(ObjectQuery query) {
        return query instanceof ArgumentQuery ? this.getMax((ArgumentQuery)query) : (short)Short.MAX_VALUE;
    }

    private short getMax(ArgumentQuery query) {
        Max annotation = query.getParameter().getAnnotation(Max.class);
        return annotation == null ? (short)Short.MAX_VALUE : this.convertToShort(annotation.value());
    }

    private short convertToShort(long value) {
        this.assertThatValueIsGreaterThatOrEqualToMinValue(value);
        this.assertThatValueIsLessThanOrEqualToMaxValue(value);
        return (short)value;
    }

    private void assertThatValueIsGreaterThatOrEqualToMinValue(long value) {
        if (value < -32768L) {
            throw new IllegalArgumentException("the value is less than the lower bound.");
        }
    }

    private void assertThatValueIsLessThanOrEqualToMaxValue(long value) {
        if (value > 32767L) {
            throw new IllegalArgumentException("The value is greater than the upper bound.");
        }
    }

    private short factory(int min, int max) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        return (short)random.nextInt(min, max + 1);
    }
}

