/*
 * Decompiled with CFR 0.152.
 */
package org.javaunit.autoparams.generator;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import org.javaunit.autoparams.generator.ObjectContainer;
import org.javaunit.autoparams.generator.ObjectGenerationContext;
import org.javaunit.autoparams.generator.ObjectGenerator;
import org.javaunit.autoparams.generator.ObjectQuery;

final class TypeMatchingGenerator
implements ObjectGenerator {
    private final Function<Type, Boolean> predicate;
    private final Function<ObjectGenerationContext, Object> factory;

    public TypeMatchingGenerator(Function<Type, Boolean> predicate, Function<ObjectGenerationContext, Object> factory) {
        this.predicate = predicate;
        this.factory = factory;
    }

    public TypeMatchingGenerator(Supplier<Object> factory, Class<?> ... candidates) {
        this(TypeMatchingGenerator.buildPredicateWithTypes(candidates), (ObjectGenerationContext context) -> factory.get());
    }

    public TypeMatchingGenerator(Function<ObjectGenerationContext, Object> factory, Class<?> ... candidates) {
        this(TypeMatchingGenerator.buildPredicateWithTypes(candidates), factory);
    }

    private static Function<Type, Boolean> buildPredicateWithTypes(Class<?> ... candidates) {
        return type -> Arrays.stream(candidates).anyMatch(candidate -> TypeMatchingGenerator.match(type, candidate));
    }

    private static boolean match(Type type, Class<?> candidate) {
        return type.equals(candidate) || type instanceof ParameterizedType && TypeMatchingGenerator.match((ParameterizedType)type, candidate);
    }

    private static boolean match(ParameterizedType type, Class<?> candidate) {
        return type.getRawType().equals(candidate);
    }

    @Override
    public ObjectContainer generate(ObjectQuery query, ObjectGenerationContext context) {
        Type type = query.getType();
        return this.predicate.apply(type) != false ? new ObjectContainer(this.factory.apply(context)) : ObjectContainer.EMPTY;
    }
}

