/*
 * Decompiled with CFR 0.152.
 */
package giis.portable.util;

import giis.portable.util.JavaCs;

public class CallStack {
    private StackTraceElement[] stack;

    public CallStack() {
        Throwable tr = new Throwable();
        this.stack = tr.getStackTrace();
    }

    public int size() {
        return this.stack.length;
    }

    public String getClassName(int position) {
        return this.stack[position].getClassName();
    }

    public String getMethodName(int position) {
        return position == 0 ? "" : this.stack[position].getMethodName();
    }

    public String getFileName(int position) {
        return this.stack[position].getFileName();
    }

    public String getFullFileName(int position) {
        String[] nameItems = JavaCs.splitByDot(this.stack[position].getClassName());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nameItems.length - 1; ++i) {
            sb.append(nameItems[i]).append("/");
        }
        sb.append(this.stack[position].getFileName());
        return sb.toString();
    }

    public int getLineNumber(int position) {
        return this.stack[position].getLineNumber();
    }

    public String getString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.stack.length; ++i) {
            sb.append("\n        " + this.getClassName(i) + " " + this.getMethodName(i) + " " + this.getLineNumber(i) + " " + this.getFileName(i));
        }
        return sb.toString();
    }
}

