/*
 * Decompiled with CFR 0.152.
 */
package giis.portable.util;

import giis.portable.util.PortableException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class FileUtil {
    private static final String UTF_8 = "UTF-8";

    private FileUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static String fileRead(String fileName, boolean throwIfNotExists) {
        try {
            File f = new File(fileName);
            if (f.exists()) {
                return FileUtils.readFileToString((File)f, (String)UTF_8);
            }
            if (throwIfNotExists) {
                throw new PortableException("File does not exist " + fileName);
            }
            return null;
        }
        catch (IOException e) {
            throw new PortableException(e);
        }
    }

    public static String fileRead(String path, String name, boolean throwIfNotExists) {
        return FileUtil.fileRead(FileUtil.getPath(path, name), throwIfNotExists);
    }

    public static String fileRead(String path, String name) {
        return FileUtil.fileRead(FileUtil.getPath(path, name), true);
    }

    public static String fileRead(String fileName) {
        return FileUtil.fileRead(fileName, true);
    }

    public static List<String> fileReadLines(String fileName) {
        return FileUtil.fileReadLines(fileName, true);
    }

    public static List<String> fileReadLines(String path, String name) {
        return FileUtil.fileReadLines(FileUtil.getPath(path, name), true);
    }

    public static List<String> fileReadLines(String fileName, boolean throwIfNotExists) {
        try {
            return FileUtils.readLines((File)new File(fileName), (String)UTF_8);
        }
        catch (IOException e) {
            if (!throwIfNotExists) {
                return new ArrayList<String>();
            }
            throw new PortableException("Error reading file " + fileName, e);
        }
    }

    public static List<String> fileReadLines(String path, String name, boolean throwIfNotExists) {
        return FileUtil.fileReadLines(FileUtil.getPath(path, name), throwIfNotExists);
    }

    public static void fileWrite(String path, String name, String content) {
        FileUtil.fileWrite(FileUtil.getPath(path, name), content);
    }

    public static void fileWrite(String fileName, String contents) {
        try {
            FileUtils.writeStringToFile((File)new File(fileName), (String)contents, (String)UTF_8);
        }
        catch (IOException e) {
            throw new PortableException("Error writing file " + fileName, e);
        }
    }

    public static void fileAppend(String path, String name, String content) {
        FileUtil.fileAppend(FileUtil.getPath(path, name), content);
    }

    public static void fileAppend(String fileName, String line) {
        try {
            FileUtils.writeStringToFile((File)new File(fileName), (String)line, (String)UTF_8, (boolean)true);
        }
        catch (IOException e) {
            throw new PortableException("Error appending to file " + fileName, e);
        }
    }

    public static void copyFile(String source, String dest) {
        FileUtil.copyFile(new File(source), new File(dest));
    }

    public static void copyFile(File source, File dest) {
        try {
            FileUtils.copyFile((File)source, (File)dest);
        }
        catch (IOException e) {
            throw new PortableException("Error copying files", e);
        }
    }

    public static List<String> getFilesMatchingWildcard(String folder, String fileNameWildcard) {
        File[] files = FileUtil.listMatchingWildcard(folder, fileNameWildcard);
        ArrayList<String> names = new ArrayList<String>();
        for (File file : files) {
            if (file.isDirectory()) continue;
            names.add(file.getName());
        }
        Collections.sort(names);
        return names;
    }

    private static File[] listMatchingWildcard(String folder, String fileNameWildcard) {
        File dir = new File(folder);
        WildcardFileFilter fileFilter = WildcardFileFilter.builder().setWildcards(new String[]{fileNameWildcard}).get();
        return dir.listFiles((FileFilter)fileFilter);
    }

    public static List<String> getFileListInDirectory(String path) {
        ArrayList<String> lst = new ArrayList<String>();
        try {
            File dir = new File(path);
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) continue;
                lst.add(file.getName());
            }
        }
        catch (RuntimeException e) {
            throw new PortableException("Can't browse directory at path " + path);
        }
        Collections.sort(lst);
        return lst;
    }

    public static void deleteFilesInDirectory(String path) {
        File dir = new File(path);
        if (dir.exists()) {
            for (File file : dir.listFiles()) {
                boolean success;
                if (file.isDirectory() || (success = file.delete())) continue;
                throw new PortableException("Can't delete file " + file.getName());
            }
        }
    }

    public static String getPath(String first, String ... more) {
        String result = first;
        if (result.startsWith(".")) {
            result = FileUtil.getFullPath(result);
        }
        for (int i = 0; i < more.length; ++i) {
            result = FilenameUtils.concat((String)result, (String)more[i]);
        }
        return result;
    }

    public static String getPath(String first, String more1) {
        return FileUtil.getPath(first, new String[]{more1});
    }

    public static String getPath(String first, String more1, String more2) {
        return FileUtil.getPath(first, new String[]{more1, more2});
    }

    public static String getFullPath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            throw new PortableException("Error getting full path of " + path, e);
        }
    }

    public static void createDirectory(String path) {
        try {
            FileUtils.forceMkdir((File)new File(path));
        }
        catch (IOException e) {
            throw new PortableException(e);
        }
    }
}

