/*
 * Decompiled with CFR 0.152.
 */
package giis.portable.util;

import java.io.InputStream;
import java.util.Properties;

public class Versions {
    private final String currentVersion;

    public Versions(Class target, String groupId, String artifactId) {
        this(groupId, artifactId);
    }

    public Versions(String groupId, String artifactId) {
        this.currentVersion = this.getVersion(this.getClass(), "/META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
    }

    public String getVersion() {
        return this.currentVersion;
    }

    private String getVersion(Class target, String pomResourcePath) {
        Package aPackage;
        String version = null;
        try {
            Properties p = new Properties();
            InputStream is = target.getResourceAsStream(pomResourcePath);
            if (is != null) {
                p.load(is);
                version = p.getProperty("version", "");
            }
        }
        catch (Exception p) {
            // empty catch block
        }
        if (version == null && (aPackage = this.getClass().getPackage()) != null && (version = aPackage.getImplementationVersion()) == null) {
            version = aPackage.getSpecificationVersion();
        }
        if (version == null) {
            version = "0.0.0";
        }
        return version;
    }
}

