/*
 * Decompiled with CFR 0.152.
 */
package giis.visualassert;

import giis.visualassert.Framework;
import giis.visualassert.FrameworkAssert;
import giis.visualassert.portable.FileUtil;
import giis.visualassert.portable.JavaCs;
import java.util.LinkedList;
import java.util.List;
import org.bitbucket.cowwoc.diffmatchpatch.DiffMatchPatch;

public abstract class AbstractVisualAssert<T extends AbstractVisualAssert<T>> {
    private boolean useLocalAbsolutePath = false;
    private String diffFileQualifier = "";
    private String diffFileEnvQualifier = "";
    private boolean showExpectedAndActual = false;
    private boolean softDifferences = false;
    protected boolean normalizeEol = false;
    private boolean brightColors = false;
    private String reportSubdir = "target";
    protected FrameworkAssert platformAssert = new FrameworkAssert(Framework.NONE);

    public T setFramework(Framework framework) {
        this.platformAssert = new FrameworkAssert(framework);
        return (T)this;
    }

    public T setReportSubdir(String reportSubdir) {
        this.reportSubdir = reportSubdir;
        return (T)this;
    }

    public T setNormalizeEol(boolean normalizeEol) {
        this.normalizeEol = normalizeEol;
        return (T)this;
    }

    public T setSoftDifferences(boolean useSoftDifferences) {
        this.softDifferences = useSoftDifferences;
        return (T)this;
    }

    public T setBrightColors(boolean useBrightColors) {
        this.brightColors = useBrightColors;
        return (T)this;
    }

    public T setDiffFileQualifier(String diffFileQualifier) {
        this.diffFileQualifier = diffFileQualifier;
        return (T)this;
    }

    public T setDiffFileEnvQualifier(String envVariable) {
        this.diffFileEnvQualifier = envVariable;
        return (T)this;
    }

    public T setUseLocalAbsolutePath(boolean useLocalAbsolutePath) {
        this.useLocalAbsolutePath = useLocalAbsolutePath;
        return (T)this;
    }

    public T setShowExpectedAndActual(boolean showExpectedAndActual) {
        this.showExpectedAndActual = showExpectedAndActual;
        return (T)this;
    }

    public T clearCurrentSequence() {
        JavaCs.clearCurrentSequence();
        return (T)this;
    }

    public void assertEquals(String expected, String actual) {
        this.assertEquals(expected, actual, "", "");
    }

    public void assertEquals(String expected, String actual, String message) {
        this.assertEquals(expected, actual, message, "");
    }

    public abstract void assertEquals(String var1, String var2, String var3, String var4);

    protected abstract String getAssertionMessage(String var1, String var2, String var3, String var4);

    protected String normalize(String value) {
        return value != null && this.normalizeEol ? value.replace("\r", "") : value;
    }

    protected boolean stringsAreEqual(String expected, String actual) {
        if (expected == null && actual == null) {
            return true;
        }
        return expected == null ? actual.equals(expected) : expected.equals(actual);
    }

    protected String getAssertionMessage(String expected, String actual, String message, String fileName, String messagePrefix) {
        String htmlDiffs = this.getHtmlDiffs(expected, actual);
        String uniqueFileName = this.writeDiffFile(htmlDiffs, fileName);
        String fullMessage = messagePrefix;
        fullMessage = fullMessage + (actual == null ? " Actual was <null>." : "");
        fullMessage = fullMessage + (expected == null ? " Expected was <null>." : "");
        fullMessage = fullMessage + (actual != null && expected != null ? " " + this.getDiffLocation(expected, actual) + "." : "");
        if (!JavaCs.isEmpty(message)) {
            fullMessage = fullMessage + "\n" + message + ".";
        }
        fullMessage = fullMessage + "\n- Visual diffs at: " + this.getFileUrl(uniqueFileName);
        if (this.platformAssert.getFramework() != Framework.NONE) {
            fullMessage = fullMessage + "\n";
        } else if (this.showExpectedAndActual) {
            fullMessage = fullMessage + "\n- Expected: <" + expected + ">.";
            fullMessage = fullMessage + "\n- Actual: <" + actual + ">.";
        }
        return fullMessage;
    }

    protected String writeDiffFile(String htmlDiffs, String fileName) {
        FileUtil.createDirectory(this.reportSubdir);
        String uniqueFileName = fileName;
        if (JavaCs.isEmpty(fileName)) {
            uniqueFileName = this.getUniqueFileName();
        }
        String uniqueFile = FileUtil.getPath(this.reportSubdir, uniqueFileName);
        FileUtil.fileWrite(uniqueFile, htmlDiffs);
        return uniqueFileName;
    }

    public String getUniqueFileName() {
        return "diff-" + (JavaCs.isEmpty(this.diffFileQualifier) ? "" : this.diffFileQualifier + "-") + (JavaCs.isEmpty(this.diffFileEnvQualifier) ? "" : JavaCs.getEnvironmentVariable(this.diffFileEnvQualifier) + "-") + JavaCs.getSequenceAndIncrement() + ".html";
    }

    public String getHtmlDiffs(String expected, String actual) {
        String diffs;
        DiffMatchPatch dmp = new DiffMatchPatch();
        expected = expected == null ? "" : expected;
        actual = actual == null ? "" : actual;
        LinkedList diff = dmp.diffMain(expected, actual);
        dmp.diffCleanupSemantic(diff);
        String string = diffs = this.softDifferences ? dmp.diffPrettyHtml((List)diff) : this.diffPrettyHtmlHard(diff);
        if (this.brightColors) {
            diffs = diffs.replace("background:#e6ffe6;", "background:#00ff00;").replace("background:#ffe6e6;", "background:#ff4000;");
        }
        return diffs;
    }

    protected String diffPrettyHtmlHard(LinkedList<DiffMatchPatch.Diff> diffs) {
        StringBuilder html = new StringBuilder();
        for (DiffMatchPatch.Diff aDiff : diffs) {
            String text = aDiff.text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\r", " ").replace("\n", "&para;\n");
            switch (aDiff.operation) {
                case INSERT: {
                    html.append("<ins style=\"background:#e6ffe6;\">").append(text).append("</ins>");
                    break;
                }
                case DELETE: {
                    html.append("<del style=\"background:#ffe6e6;\">").append(text).append("</del>");
                    break;
                }
                case EQUAL: {
                    html.append("<span>").append(text).append("</span>");
                }
            }
        }
        return "<pre>\n" + html.toString() + "\n</pre>";
    }

    protected String diffPrettyHtmlHardOld(LinkedList<DiffMatchPatch.Diff> diffs) {
        StringBuilder html = new StringBuilder();
        for (DiffMatchPatch.Diff aDiff : diffs) {
            String text = aDiff.text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "&para;<br>");
            switch (aDiff.operation) {
                case INSERT: {
                    html.append("<ins style=\"background:#e6ffe6;\">").append(text.replace(" ", "&nbsp;")).append("</ins>");
                    break;
                }
                case DELETE: {
                    html.append("<del style=\"background:#ffe6e6;\">").append(text.replace(" ", "&nbsp;")).append("</del>");
                    break;
                }
                case EQUAL: {
                    html.append("<span>").append(text).append("</span>");
                }
            }
        }
        return html.toString();
    }

    protected String getFileUrl(String uniqueFileName) {
        String fileUrl = FileUtil.getPath(this.reportSubdir, uniqueFileName);
        if (this.useLocalAbsolutePath) {
            String absPath = FileUtil.getFullPath(fileUrl).replace("\\", "/");
            fileUrl = "file://" + (absPath.startsWith("/") ? "" : "/") + absPath;
        }
        return fileUrl;
    }

    public String getDiffLocation(String expected, String actual) {
        if ("".equals(actual) && !"".equals(expected)) {
            return "Actual is empty";
        }
        if (!"".equals(actual) && "".equals(expected)) {
            return "Expected is empty";
        }
        int line = 0;
        int column = 0;
        for (int i = 0; i < expected.length(); ++i) {
            char current = expected.charAt(i);
            if (i < actual.length() && current != actual.charAt(i)) {
                return "First diff at line " + (line + 1) + " column " + (column + 1);
            }
            if (i >= actual.length()) {
                return "Actual is contained in expected";
            }
            if (current == '\n') {
                ++line;
                column = 0;
                continue;
            }
            ++column;
        }
        if (expected.length() < actual.length()) {
            return "Expected is contained in actual";
        }
        return "No diffs";
    }
}

