/*
 * Decompiled with CFR 0.152.
 */
package giis.visualassert;

import giis.visualassert.AbstractVisualAssert;
import giis.visualassert.portable.CallStack;
import giis.visualassert.portable.JavaCs;
import java.util.ArrayList;
import java.util.List;

public class SoftVisualAssert
extends AbstractVisualAssert<SoftVisualAssert> {
    private List<String> assertionMessages;
    private List<String> userMessages;
    private List<String> failureExpected;
    private List<String> failureActual;
    private int callStackLength = 1;

    public SoftVisualAssert() {
        this.assertClear();
    }

    public SoftVisualAssert setCallStackLength(int length) {
        this.callStackLength = length;
        return this;
    }

    @Override
    public void assertEquals(String expected, String actual, String message, String fileName) {
        if (!this.stringsAreEqual(expected = this.normalize(expected), actual = this.normalize(actual))) {
            this.throwAssertionError(this.getAssertionMessage(expected, actual, message, fileName), message, expected, actual);
        }
    }

    protected void throwAssertionError(String message, String userMessage, String expected, String actual) {
        if (this.callStackLength > 0) {
            CallStack stack = new CallStack();
            message = message + (message.endsWith("\n") ? "" : "\n") + this.getStackTraceMessage(stack);
        }
        this.assertionMessages.add(message);
        this.userMessages.add(userMessage);
        this.failureExpected.add(expected);
        this.failureActual.add(actual);
    }

    private String getStackTraceMessage(CallStack stack) {
        StringBuilder sb = new StringBuilder();
        boolean skip = true;
        int countTraces = 0;
        for (int i = 0; i < stack.size(); ++i) {
            if (!(!skip || stack.getClassName(i).startsWith("giis.visualassert.portable.CallStack") || stack.getClassName(i).startsWith("giis.visualassert.AbstractVisualAssert") || stack.getClassName(i).startsWith("giis.visualassert.SoftVisualAssert") || stack.getClassName(i).startsWith("giis.visualassert.VisualAssert") || stack.getClassName(i).startsWith("Giis.Visualassert.portable.CallStack") || stack.getClassName(i).startsWith("Giis.Visualassert.AbstractVisualassert") || stack.getClassName(i).startsWith("Giis.Visualassert.SoftVisualAssert") || stack.getClassName(i).startsWith("Giis.Visualassert.VisualAssert") || stack.getClassName(i).startsWith("System.Environment"))) {
                skip = false;
            }
            if (skip) continue;
            sb.append("\n    at ").append(stack.getClassName(i) + "." + stack.getMethodName(i) + "(" + stack.getFileName(i) + ":" + stack.getLineNumber(i) + ")");
            if (++countTraces < this.callStackLength) continue;
            return "- Call Stack:" + sb.toString();
        }
        return "";
    }

    @Override
    protected String getAssertionMessage(String expected, String actual, String message, String fileName) {
        return super.getAssertionMessage(expected, actual, message, fileName, this.getMessagePrefix() + " Strings are different.");
    }

    private String getMessagePrefix() {
        return "Failure " + (this.assertionMessages.size() + 1) + ":";
    }

    public void assertAll(String aggregateFileName) {
        if (this.assertionMessages.size() == 0) {
            return;
        }
        if (aggregateFileName == null) {
            aggregateFileName = "";
        }
        StringBuilder allMsg = new StringBuilder();
        allMsg.append("There are " + this.assertionMessages.size() + " failed assertion(s)");
        if (!"".equals(aggregateFileName)) {
            allMsg.append("\nAggregated visual diffs at: " + this.getFileUrl(aggregateFileName));
        }
        for (String msg : this.assertionMessages) {
            allMsg.append("\n" + msg);
        }
        String expected = this.composeOutputInfo(this.failureExpected);
        String actual = this.composeOutputInfo(this.failureActual);
        if (!"".equals(aggregateFileName)) {
            String htmlDiff = this.getHtmlDiffs(expected, actual);
            this.writeDiffFile(htmlDiff, aggregateFileName);
        }
        this.assertClear();
        if (!this.stringsAreEqual(expected, actual)) {
            this.platformAssert.failNotEquals(expected, actual, allMsg.toString());
        }
    }

    public void assertAll() {
        this.assertAll("");
    }

    private String composeOutputInfo(List<String> expectedOrActual) {
        StringBuilder sb = new StringBuilder();
        sb.append("Aggregated failures:");
        for (int i = 0; i < expectedOrActual.size(); ++i) {
            sb.append("\n").append(this.getAggregateFailureHeader(i, this.userMessages.get(i))).append("\n").append(expectedOrActual.get(i) == null ? "" : expectedOrActual.get(i));
        }
        return sb.toString();
    }

    public String getAggregateFailureHeader(int failureNumber, String userMessage) {
        return "\n---------------------------\n-------- Failure " + (failureNumber + 1) + " --------" + this.getUserMessage(userMessage) + "\n---------------------------";
    }

    private String getUserMessage(String userMessage) {
        if (JavaCs.isEmpty(userMessage)) {
            return "";
        }
        return "\n-------- " + userMessage;
    }

    public void assertClear() {
        this.assertionMessages = new ArrayList<String>();
        this.userMessages = new ArrayList<String>();
        this.failureExpected = new ArrayList<String>();
        this.failureActual = new ArrayList<String>();
    }

    public int getFailureCount() {
        return this.assertionMessages.size();
    }

    public void fail() {
        this.fail("");
    }

    public void fail(String message) {
        String messageInfo = "Fail assertion raised." + ("".equals(message) ? "" : "\n" + message);
        this.throwAssertionError(this.getMessagePrefix() + " " + messageInfo, message, "", messageInfo);
    }
}

