/*
 * Decompiled with CFR 0.152.
 */
package giis.visualassert.portable;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class FileUtil {
    private static final String UTF_8 = "UTF-8";

    private FileUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static String fileRead(String fileName, boolean throwIfNotExists) {
        try {
            File f = new File(fileName);
            if (f.exists()) {
                return FileUtils.readFileToString((File)f, (String)UTF_8);
            }
            if (throwIfNotExists) {
                throw new RuntimeException("File does not exist " + fileName);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fileRead(String fileName) {
        return FileUtil.fileRead(fileName, true);
    }

    public static void fileWrite(String fileName, String contents) {
        try {
            FileUtils.writeStringToFile((File)new File(fileName), (String)contents, (String)UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing file " + fileName, e);
        }
    }

    public static List<String> getFileListInDirectory(String path) {
        ArrayList<String> lst = new ArrayList<String>();
        try {
            File dir = new File(path);
            for (File file : dir.listFiles()) {
                lst.add(file.getName());
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Can't browse directory at path " + path);
        }
        return lst;
    }

    public static String getPath(String first, String ... more) {
        String result = first;
        if (result.startsWith(".")) {
            result = FileUtil.getFullPath(result);
        }
        for (int i = 0; i < more.length; ++i) {
            result = FilenameUtils.concat((String)result, (String)more[i]);
        }
        return result;
    }

    public static String getPath(String first, String more1) {
        return FileUtil.getPath(first, new String[]{more1});
    }

    public static String getFullPath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting full path of " + path, e);
        }
    }

    public static void createDirectory(String path) {
        try {
            FileUtils.forceMkdir((File)new File(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

