/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorexclient;

import io.github.javpower.vectorexclient.builder.QueryBuilder;
import io.github.javpower.vectorexclient.entity.VectoRexEntity;
import io.github.javpower.vectorexclient.req.CollectionDataAddReq;
import io.github.javpower.vectorexclient.req.CollectionDataDelReq;
import io.github.javpower.vectorexclient.req.CollectionDataPageReq;
import io.github.javpower.vectorexclient.req.CollectionDataQueryReq;
import io.github.javpower.vectorexclient.req.LoginUser;
import io.github.javpower.vectorexclient.req.VectoRexCollectionReq;
import io.github.javpower.vectorexclient.res.PageResult;
import io.github.javpower.vectorexclient.res.ServerResponse;
import io.github.javpower.vectorexclient.res.VectorSearchResult;
import io.github.javpower.vectorexclient.util.GsonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class VectorRexClient {
    private static final Logger log = LoggerFactory.getLogger(VectorRexClient.class);
    private static final long TOKEN_EXPIRE_TIME = 7080000L;
    private final String baseUri;
    private final String username;
    private final String password;
    private final OkHttpClient okHttpClient;
    private String token;
    private long tokenExpireTime;

    public VectorRexClient(String baseUri, String username, String password) {
        this.baseUri = baseUri;
        this.username = username;
        this.password = password;
        this.okHttpClient = new OkHttpClient();
        try {
            this.login();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ServerResponse<Void> createCollection(VectoRexCollectionReq req) {
        return this.executeRequest("/vectorex/add/collections", req);
    }

    public ServerResponse<Void> delCollection(String collection) {
        return this.executeRequest("/vectorex/del/collections/" + collection);
    }

    public ServerResponse<List<VectoRexEntity>> getCollections() {
        ServerResponse response = this.executeRequest("/vectorex/get/collections");
        if (response.isSuccess()) {
            List data = (List)response.getData();
            ArrayList<VectoRexEntity> vectoRexEntities = new ArrayList<VectoRexEntity>();
            for (Map datum : data) {
                VectoRexEntity o = (VectoRexEntity)GsonUtil.convertMapToType(datum, VectoRexEntity.class);
                vectoRexEntities.add(o);
            }
            ServerResponse<List<VectoRexEntity>> serverResponse = ServerResponse.createBySuccess(vectoRexEntities);
            return serverResponse;
        }
        return ServerResponse.createByError(response.getMsg());
    }

    public ServerResponse<Void> addCollectionData(CollectionDataAddReq req) {
        return this.executeRequest("/vectorex/collections/data/add", req);
    }

    public ServerResponse<Void> updateCollectionData(CollectionDataAddReq req) {
        return this.executeRequest("/vectorex/collections/data/update", req);
    }

    public ServerResponse<Void> deleteCollectionData(CollectionDataDelReq req) {
        return this.executeRequest("/vectorex/collections/data/del", req);
    }

    public ServerResponse<List<VectorSearchResult>> queryCollectionData(QueryBuilder queryBuilder) {
        CollectionDataPageReq queryReq = queryBuilder.build();
        CollectionDataQueryReq req = new CollectionDataQueryReq();
        BeanUtils.copyProperties((Object)queryReq, (Object)req);
        ServerResponse response = this.executeRequest("/vectorex/collections/data/query", req);
        if (response.isSuccess()) {
            ArrayList<VectorSearchResult> vectorSearchResults = new ArrayList<VectorSearchResult>();
            List data = (List)response.getData();
            for (Map datum : data) {
                VectorSearchResult o = (VectorSearchResult)GsonUtil.convertMapToType(datum, VectorSearchResult.class);
                vectorSearchResults.add(o);
            }
            ServerResponse<List<VectorSearchResult>> serverResponse = ServerResponse.createBySuccess(vectorSearchResults);
            return serverResponse;
        }
        return ServerResponse.createByError(response.getMsg());
    }

    public ServerResponse<PageResult<VectorSearchResult>> pageCollectionData(QueryBuilder queryBuilder) {
        ServerResponse response = this.executeRequest("/vectorex/collections/data/page", queryBuilder.build());
        if (response.isSuccess()) {
            Object data = response.getData();
            String s = GsonUtil.toJson(data);
            PageResult pageResult = GsonUtil.fromJson(s, PageResult.class);
            ArrayList<VectorSearchResult> vectorSearchResults = new ArrayList<VectorSearchResult>();
            List resultData = pageResult.getData();
            for (Map datum : resultData) {
                VectorSearchResult o = (VectorSearchResult)GsonUtil.convertMapToType(datum, VectorSearchResult.class);
                vectorSearchResults.add(o);
            }
            PageResult resultPageResult = new PageResult(vectorSearchResults, pageResult.getTotalRecords(), pageResult.getPageIndex(), pageResult.getPageSize());
            ServerResponse<PageResult<VectorSearchResult>> serverResponse = ServerResponse.createBySuccess(resultPageResult);
            return serverResponse;
        }
        return ServerResponse.createByError(response.getMsg());
    }

    private <T> ServerResponse<T> executeRequest(String path) {
        return this.executeRequest(path, new HashMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> ServerResponse<T> executeRequest(String path, Object reqBody) {
        log.debug("executeRequest path: {}, reqBody: {}", (Object)path, (Object)GsonUtil.toJson(reqBody));
        try {
            this.checkToken();
            String url = this.baseUri + path;
            RequestBody requestBody = reqBody != null ? RequestBody.create((String)GsonUtil.toJson(reqBody), (MediaType)MediaType.parse((String)"application/json; charset=utf-8")) : null;
            Request request = new Request.Builder().url(url).post(requestBody).header("token", this.token).build();
            try (Response response = this.okHttpClient.newCall(request).execute();){
                ServerResponse serverResponse;
                String responseBody = response.body().string();
                ServerResponse serverResponse2 = serverResponse = GsonUtil.fromJson(responseBody, ServerResponse.class);
                return serverResponse2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkToken() throws IOException {
        if (System.currentTimeMillis() >= this.tokenExpireTime) {
            this.login();
        }
    }

    private void login() throws IOException {
        block13: {
            String url = this.baseUri + "/vectorex/login";
            LoginUser loginUser = new LoginUser(this.username, this.password);
            RequestBody requestBody = RequestBody.create((String)GsonUtil.toJson(loginUser), (MediaType)MediaType.parse((String)"application/json; charset=utf-8"));
            Request request = new Request.Builder().url(url).post(requestBody).build();
            try (Response response = this.okHttpClient.newCall(request).execute();){
                String responseBody = response.body().string();
                ServerResponse serverResponse = GsonUtil.fromJson(responseBody, ServerResponse.class);
                if (serverResponse.isSuccess()) {
                    this.token = (String)serverResponse.getData();
                    this.tokenExpireTime = System.currentTimeMillis() + 7080000L;
                    break block13;
                }
                throw new RuntimeException("\u767b\u5f55\u5931\u8d25\uff1a" + serverResponse.getMsg());
            }
        }
    }

    public void close() {
    }
}

