package io.github.javpower.vectorex.keynote;

import io.github.javpower.vectorex.keynote.core.DbData;
import io.github.javpower.vectorex.keynote.model.VectorFiled;
import io.github.javpower.vectorex.keynote.storage.MapDBManager;
import io.github.javpower.vectorex.keynote.storage.MapDBStorage;
import org.mapdb.DB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class VectorDB {
    private static final Logger logger = LoggerFactory.getLogger(MapDBManager.class);

    public static MapDBManager mapDBManager;

    public VectorDB(String dbPath) {
        ensureDirectoryExists(dbPath);
        if(mapDBManager==null){
            mapDBManager=new MapDBManager(dbPath);
        }
    }

    public static void createCollection(String collection, int maxDataCount, List<VectorFiled> vectorFiled){
        mapDBManager.createCollection(collection, maxDataCount, vectorFiled);
        loadDataIntoManagers(collection);
    }

    public static void delCollection(String collection){
        DB db = mapDBManager.getDb();
        MapDBStorage storage = mapDBManager.getMap(collection);
        storage.getMap().clear();
        mapDBManager.delCollection(collection);
        db.commit();
    }
    public static MapDBStorage  getDataStore(String collection){
        return mapDBManager.getMap(collection);
    }
    /**
     * 从数据库加载数据到索引管理器
     */
    private static void loadDataIntoManagers(String collection) {
        MapDBStorage dataStore = mapDBManager.getMap(collection);
        List<DbData> allData = dataStore.getAll();
        for (DbData data : allData) {
            dataStore.loadDataIntoManagers(data);
        }
    }

    /**
     * 确保目录存在
     *
     * @param dbPath 数据库文件路径
     * @throws RuntimeException 如果目录创建失败
     */
    private boolean ensureDirectoryExists(String dbPath) {
        try {
            // 获取父目录并创建（如果不存在）
            Path parentDir = Paths.get(dbPath).getParent();
            if (parentDir != null) {
                Files.createDirectories(parentDir);
                return true;
            }
            return false;
        } catch (Exception e) {
            throw new RuntimeException("Failed to create directory for database: " + dbPath, e);
        }
    }
    public void init() {
        logger.info("------Init DBManager Success-----");
    }
}