package io.github.javpower.vectorex.keynote.analysis;

import java.util.regex.Pattern;

public class CharacterUtil {
    public static Pattern reSkip = Pattern.compile("(\\d+\\.\\d+|[a-zA-Z0-9]+)");
    private static final char[] connectors = new char[] {'+', '#', '&', '.', '_', '-'};

    public static boolean isChineseLetter(char ch) {
        return ch >= 0x4E00 && ch <= 0x9FA5;
    }

    public static boolean isEnglishLetter(char ch) {
        return (ch >= 'A' && ch <= 'Z') || (ch >= 'a' && ch <= 'z');
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isConnector(char ch) {
        for (char connector : connectors) {
            if (ch == connector) return true;
        }
        return false;
    }

    public static boolean isChineseOrEnglishLetter(char ch) {
        return isChineseLetter(ch) || isEnglishLetter(ch);
    }

    public static char regularize(char input) {
        if (input == 12288) {
            return ' ';
        } else if (input >= 65281 && input <= 65374) {
            return (char) (input - 65248);
        } else if (input >= 'A' && input <= 'Z') {
            return (char) (input + 32);
        }
        return input;
    }
}