package io.github.javpower.vectorex.keynote.analysis;

public class Hit {
    private static final int UNMATCH = 0x00000000;
    private static final int MATCH = 0x00000001;
    private static final int PREFIX = 0x00000010;

    private int state = UNMATCH;
    private TrieSegment matchedSegment;
    private int begin;
    private int end;

    public boolean isMatch() {
        return (state & MATCH) > 0;
    }

    public void setMatch() {
        state |= MATCH;
    }

    public boolean isPrefix() {
        return (state & PREFIX) > 0;
    }

    public void setPrefix() {
        state |= PREFIX;
    }

    public boolean isUnmatch() {
        return state == UNMATCH;
    }

    public void setUnmatch() {
        state = UNMATCH;
    }

    public TrieSegment getMatchedSegment() {
        return matchedSegment;
    }

    public void setMatchedSegment(TrieSegment segment) {
        this.matchedSegment = segment;
    }

    public int getBegin() {
        return begin;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public int getEnd() {
        return end;
    }

    public void setEnd(int end) {
        this.end = end;
    }
}