package io.github.javpower.vectorex.keynote.analysis;

public class SegToken {
    private final String word;
    private final int startOffset;
    private final int endOffset;

    public SegToken(String word, int startOffset, int endOffset) {
        this.word = word;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }
    public String getWord() {
        return word;
    }

    @Override
    public String toString() {
        return String.format("[%s, start: %d, end: %d]", word, startOffset, endOffset);
    }
}