package io.github.javpower.vectorex.keynote.analysis;

public class SegmentationStrategyFactory {
    public static SegmentationStrategy getStrategy(SegMode mode) {
        switch (mode) {
            case INDEX:
                return new IndexSegmentationStrategy();
            case SEARCH:
                return new SearchSegmentationStrategy();
            default:
                throw new IllegalArgumentException("Unsupported segmentation mode: " + mode);
        }
    }
}