package io.github.javpower.vectorex.keynote.analysis;

import java.nio.file.Path;
import java.util.List;

public class TextSegmenter {
    private final SegmentationStrategy strategy;

    public TextSegmenter(SegMode mode) {
        this.strategy = SegmentationStrategyFactory.getStrategy(mode);
    }

    public List<SegToken> process(String text) {
        return strategy.segment(text);
    }

    public void initUserDictionary(Path path) {
        DictionaryManager.getInstance().loadUserDictionary(path.toString());
    }
}