package io.github.javpower.vectorex.keynote.core;

import io.github.javpower.vectorex.keynote.knn.Item;

public class VectorData implements Item<String, float[]> {

    private static final long serialVersionUID = 1L;
    private final String id;
    private final float[] vector;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private String name;

    public VectorData(String id, float[] vector) {
        this.id = id;
        this.vector = vector;
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public float[] vector() {
        return vector;
    }

    @Override
    public int dimensions() {
        return vector.length;
    }

}