package io.github.javpower.vectorex.keynote.graph.entity;

import io.github.javpower.vectorex.keynote.graph.core.GraphDB;

public class AttributeEdge extends Relationship {
    public AttributeEdge(String id, String startNodeId, String endNodeId, double weight) {
        super(id, startNodeId, endNodeId, "WEIGHTED_EDGE");
        if (weight <= 0) throw new IllegalArgumentException("Weight must be positive");
        this.setProperty("weight", weight);
    }

    public void updateWeight(double newWeight, GraphDB db) {
        if (newWeight <= 0) throw new IllegalArgumentException("Weight must be positive");
        this.setProperty("weight", newWeight);

        // 更新起点和终点的缓存
        db.updateAdjacencyCache(this.getStartNodeId());
        db.updateAdjacencyCache(this.getEndNodeId());
    }
}