package io.github.javpower.vectorex.keynote.graph.entity;

import java.io.Serializable;
import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;

public class Node implements Serializable {
    private String id;
    private Set<String> labels = new HashSet<>();
    private Map<String, Object> properties = new HashMap<>();
    private List<Relationship> outgoingEdges = new CopyOnWriteArrayList<>();

    public Node(String id) {
        this.id = id;
    }

    // 内部使用的可修改列表
    public List<Relationship> getOutgoingEdgesInternal() {
        return outgoingEdges;
    }

    // 外部访问的不可修改视图
    public List<Relationship> getOutgoingEdges() {
        return Collections.unmodifiableList(outgoingEdges);
    }

    // 其他方法保持不变...
    public void addLabel(String label) {
        labels.add(label);
    }

    public void removeLabel(String label) {
        labels.remove(label);
    }

    public void setProperty(String key, Object value) {
        properties.put(key, value);
    }

    public Object removeProperty(String key) {
        return properties.remove(key);
    }

    public void addEdge(Relationship edge) {
        outgoingEdges.add(edge);
    }

    public void removeEdge(String edgeId) {
        outgoingEdges.removeIf(e -> e.getId().equals(edgeId));
    }

    public String getId() {
        return id;
    }

    public Set<String> getLabels() {
        return Collections.unmodifiableSet(labels);
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(properties);
    }
    public Object getProperty(String key) {
        return properties.get(key);
    }
}