package io.github.javpower.vectorex.keynote.graph.entity;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Relationship implements Serializable {
    private final String id;
    private final String startNodeId;
    private final String endNodeId;
    private final String type;
    private final Map<String, Object> properties = new HashMap<>();

    public Relationship(String id, String startNodeId, String endNodeId, String type) {
        this.id = id;
        this.startNodeId = startNodeId;
        this.endNodeId = endNodeId;
        this.type = type;
    }

    public void setProperty(String key, Object value) {
        properties.put(key, value);
    }

    public Object removeProperty(String key) {
        return properties.remove(key);
    }

    public String getId() {
        return id;
    }

    public String getStartNodeId() {
        return startNodeId;
    }

    public String getEndNodeId() {
        return endNodeId;
    }

    public String getType() {
        return type;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(properties);
    }
}