package io.github.javpower.vectorex.keynote.index.scalar;

public class RangeCondition {
    private final Comparable<?> fromKey; // 范围起点
    private final Comparable<?> toKey;   // 范围终点
    private final boolean includeFrom;  // 是否包含起点
    private final boolean includeTo;    // 是否包含终点

    public RangeCondition(Comparable<?> fromKey, Comparable<?> toKey, boolean includeFrom, boolean includeTo) {
        this.fromKey = fromKey;
        this.toKey = toKey;
        this.includeFrom = includeFrom;
        this.includeTo = includeTo;
    }

    public Comparable<?> getFromKey() {
        return fromKey;
    }

    public Comparable<?> getToKey() {
        return toKey;
    }

    public boolean isIncludeFrom() {
        return includeFrom;
    }

    public boolean isIncludeTo() {
        return includeTo;
    }
}