package io.github.javpower.vectorex.keynote.index.vector;

import io.github.javpower.vectorex.keynote.core.VectorData;
import io.github.javpower.vectorex.keynote.core.VectorSearchResult;
import io.github.javpower.vectorex.keynote.model.MetricType;

import java.util.List;
import java.util.Set;

public class VectorIndexManager {

    private HNSWIndex hnswIndex;

    public VectorIndexManager(int dimensions, int maxDateCount, MetricType type) {
        this.hnswIndex = new HNSWIndex(dimensions,maxDateCount,type);
    }

    public void index(VectorData data) {
        hnswIndex.add(data);
    }
    public void remove(String id) {
        hnswIndex.remove(id);
    }
    public void update(VectorData data){
        remove(data.id());
        index(data);
    }

    public List<VectorSearchResult> search(List<Float> queryVector, int k) {
        return hnswIndex.search(queryVector, k);
    }
    public List<VectorSearchResult> search(List<Float> queryVector, int k, Set<String> includedIds) {
        return hnswIndex.search(queryVector, k,includedIds);
    }
}