package io.github.javpower.vectorex.keynote.model;

import io.github.javpower.vectorex.keynote.query.ConditionBuilder;

public class ConditionFiled {

    private String operator;
    private String field;
    private Object value;
    private Comparable start;
    private Comparable end;
    private ConditionBuilder conditionBuilder;

    public ConditionFiled(String operator, String field, Comparable start, Comparable end) {
        this.operator = operator;
        this.field = field;
        this.start = start;
        this.end = end;
    }

    public ConditionFiled(String operator, String field, Object value) {
        this.operator = operator;
        this.field = field;
        this.value = value;
    }

    public ConditionFiled(String operator, ConditionBuilder conditionBuilder) {
        this.operator = operator;
        this.conditionBuilder = conditionBuilder;
    }

    public ConditionBuilder getConditionBuilder() {
        return conditionBuilder;
    }

    public void setConditionBuilder(ConditionBuilder conditionBuilder) {
        this.conditionBuilder = conditionBuilder;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Comparable value) {
        this.value = value;
    }

    public Comparable getStart() {
        return start;
    }

    public void setStart(Comparable start) {
        this.start = start;
    }

    public Comparable getEnd() {
        return end;
    }

    public void setEnd(Comparable end) {
        this.end = end;
    }
}
