package io.github.javpower.vectorex.keynote.storage;

import io.github.javpower.vectorex.keynote.core.DbData;
import io.github.javpower.vectorex.keynote.core.VectorSearchResult;
import io.github.javpower.vectorex.keynote.query.ConditionBuilder;

import java.util.List;

public interface DataStore {

    // 保存单个向量数据
    void save(DbData data);

    // 批量保存向量数据
    void saveAll(List<DbData> dataList);

    // 更新单个向量数据
    void update(DbData data);

    // 根据 ID 获取向量数据
    DbData get(String id);

    // 获取所有向量数据
    List<DbData> getAll();

    // 根据 ID 删除向量数据
    void delete(String id);

    // 批量删除向量数据
    void deleteAll(List<String> ids);

    // 关闭存储连接
    void close();


    //向量查询
    List<VectorSearchResult> search(String annsField, List<Float> queryVector, int k, ConditionBuilder conditionBuilder);
    List<VectorSearchResult> search(String annsField, String queryVector, int k, ConditionBuilder conditionBuilder);
    List<VectorSearchResult> query(ConditionBuilder conditionBuilder);

    void loadDataIntoManagers(DbData data);
}