package io.github.javpower.vectorex.keynote.storage;

import io.github.javpower.vectorex.keynote.core.DbData;
import io.github.javpower.vectorex.keynote.model.VectorFiled;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
/**
 * MapDBManager
 */
public class MapDBManager {
    private static final Logger logger = LoggerFactory.getLogger(MapDBManager.class);
    private DB db;
    private Map<String, MapDBStorage> maps = new ConcurrentHashMap<>();

    public MapDBManager(String dbPath) {
        try {
            db = DBMaker.fileDB(dbPath).closeOnJvmShutdown().make();
            logger.info("MapDB initialized at: {}", dbPath);
        } catch (Exception e) {
            logger.error("Failed to initialize MapDB", e);
            throw new RuntimeException("Failed to initialize MapDB", e);
        }
    }

    public void createCollection(String name, int maxDataCount, List<VectorFiled> vectorFiled) {
        HTreeMap<String, DbData> mapdd = (HTreeMap<String, DbData>)db.hashMap(name).createOrOpen();
        MapDBStorage mapDBStorage = new MapDBStorage(db,mapdd, maxDataCount, vectorFiled);
        maps.put(name,mapDBStorage);
    }

    public MapDBStorage getMap(String name) {
        return maps.computeIfAbsent(name, n -> maps.get(n));
    }
   public DB getDb() {
       return db;
   }
    public void close() {
        try {
            db.close();
            logger.info("MapDB closed");
        } catch (Exception e) {
            logger.error("Failed to close MapDB", e);
            throw new RuntimeException("Failed to close MapDB", e);
        }
    }

    public void delCollection(String collection) {
       maps.remove(collection);
    }
}
