/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote;

import io.github.javpower.vectorex.keynote.core.DbData;
import io.github.javpower.vectorex.keynote.model.VectorFiled;
import io.github.javpower.vectorex.keynote.storage.MapDBManager;
import io.github.javpower.vectorex.keynote.storage.MapDBStorage;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.mapdb.DB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorDB {
    private static final Logger logger = LoggerFactory.getLogger(MapDBManager.class);
    public static MapDBManager mapDBManager;

    public VectorDB(String dbPath) {
        this.ensureDirectoryExists(dbPath);
        if (mapDBManager == null) {
            mapDBManager = new MapDBManager(dbPath);
        }
    }

    public static void createCollection(String collection, int maxDataCount, List<VectorFiled> vectorFiled) {
        mapDBManager.createCollection(collection, maxDataCount, vectorFiled);
        VectorDB.loadDataIntoManagers(collection);
    }

    public static void delCollection(String collection) {
        DB db = mapDBManager.getDb();
        MapDBStorage storage = mapDBManager.getMap(collection);
        storage.getMap().clear();
        mapDBManager.delCollection(collection);
        db.commit();
    }

    public static MapDBStorage getDataStore(String collection) {
        return mapDBManager.getMap(collection);
    }

    private static void loadDataIntoManagers(String collection) {
        MapDBStorage dataStore = mapDBManager.getMap(collection);
        List<DbData> allData = dataStore.getAll();
        for (DbData data : allData) {
            dataStore.loadDataIntoManagers(data);
        }
    }

    private boolean ensureDirectoryExists(String dbPath) {
        try {
            Path parentDir = Paths.get(dbPath, new String[0]).getParent();
            if (parentDir != null) {
                Files.createDirectories(parentDir, new FileAttribute[0]);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create directory for database: " + dbPath, e);
        }
    }

    public void init() {
        logger.info("------Init DBManager Success-----");
    }
}

