/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.graph.core;

import io.github.javpower.vectorex.keynote.graph.core.GraphDB;
import io.github.javpower.vectorex.keynote.graph.entity.EdgeInfo;
import io.github.javpower.vectorex.keynote.graph.entity.Node;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class AdjacencyCache {
    private final GraphDB graphDB;
    private final Map<String, List<EdgeInfo>> outEdges = new ConcurrentHashMap<String, List<EdgeInfo>>();
    private final Map<String, List<EdgeInfo>> inEdges = new ConcurrentHashMap<String, List<EdgeInfo>>();

    public AdjacencyCache(GraphDB graphDB) {
        this.graphDB = graphDB;
        this.initializeCache();
    }

    private void initializeCache() {
        this.graphDB.getAllNodeIds().parallelStream().forEach(nodeId -> {
            this.updateOutEdges((String)nodeId);
            this.updateInEdges((String)nodeId);
        });
    }

    public void updateCacheForNode(String nodeId) {
        this.outEdges.remove(nodeId);
        this.inEdges.remove(nodeId);
        this.updateOutEdges(nodeId);
        this.updateInEdges(nodeId);
    }

    private void updateOutEdges(String nodeId) {
        Node node = this.graphDB.getNode(nodeId);
        if (node != null) {
            List outgoing = node.getOutgoingEdges().stream().map(rel -> new EdgeInfo(rel.getEndNodeId(), (Double)rel.getProperties().getOrDefault("weight", 1.0))).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
            this.outEdges.put(nodeId, outgoing);
        }
    }

    private void updateInEdges(String nodeId) {
        List incoming = this.graphDB.getInEdges(nodeId).stream().map(rel -> new EdgeInfo(rel.getStartNodeId(), (Double)rel.getProperties().getOrDefault("weight", 1.0))).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
        this.inEdges.put(nodeId, incoming);
    }

    public List<EdgeInfo> getOutEdges(String nodeId) {
        return this.outEdges.getOrDefault(nodeId, Collections.emptyList());
    }

    public List<EdgeInfo> getInEdges(String nodeId) {
        return this.inEdges.getOrDefault(nodeId, Collections.emptyList());
    }
}

