/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.graph.entity;

import io.github.javpower.vectorex.keynote.graph.core.GraphDB;
import io.github.javpower.vectorex.keynote.graph.entity.Relationship;

public class AttributeEdge
extends Relationship {
    public AttributeEdge(String id, String startNodeId, String endNodeId, double weight) {
        super(id, startNodeId, endNodeId, "WEIGHTED_EDGE");
        if (weight <= 0.0) {
            throw new IllegalArgumentException("Weight must be positive");
        }
        this.setProperty("weight", weight);
    }

    public void updateWeight(double newWeight, GraphDB db) {
        if (newWeight <= 0.0) {
            throw new IllegalArgumentException("Weight must be positive");
        }
        this.setProperty("weight", newWeight);
        db.updateAdjacencyCache(this.getStartNodeId());
        db.updateAdjacencyCache(this.getEndNodeId());
    }
}

