/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.graph.entity;

import io.github.javpower.vectorex.keynote.graph.entity.Relationship;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class Node
implements Serializable {
    private String id;
    private Set<String> labels = new HashSet<String>();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private List<Relationship> outgoingEdges = new CopyOnWriteArrayList<Relationship>();

    public Node(String id) {
        this.id = id;
    }

    public List<Relationship> getOutgoingEdgesInternal() {
        return this.outgoingEdges;
    }

    public List<Relationship> getOutgoingEdges() {
        return Collections.unmodifiableList(this.outgoingEdges);
    }

    public void addLabel(String label) {
        this.labels.add(label);
    }

    public void removeLabel(String label) {
        this.labels.remove(label);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object removeProperty(String key) {
        return this.properties.remove(key);
    }

    public void addEdge(Relationship edge) {
        this.outgoingEdges.add(edge);
    }

    public void removeEdge(String edgeId) {
        this.outgoingEdges.removeIf(e -> e.getId().equals(edgeId));
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getLabels() {
        return Collections.unmodifiableSet(this.labels);
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }
}

