/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.graph.test;

import io.github.javpower.vectorex.keynote.graph.core.GraphDB;
import io.github.javpower.vectorex.keynote.graph.entity.AttributeEdge;
import io.github.javpower.vectorex.keynote.graph.entity.Node;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GraphTest {
    public static void main(String[] args) {
        GraphDB db = new GraphDB("test1.db");
        Arrays.asList("A", "B", "C", "D", "E", "F", "G").forEach(id -> {
            Node node = new Node((String)id);
            node.addLabel("TestNode");
            db.addNode(node);
        });
        List<AttributeEdge> edges = Arrays.asList(GraphTest.createEdge(db, "e1", "A", "B", 3.0), GraphTest.createEdge(db, "e2", "A", "D", 1.0), GraphTest.createEdge(db, "e3", "B", "C", 2.0), GraphTest.createEdge(db, "e4", "D", "C", 4.0), GraphTest.createEdge(db, "e5", "C", "E", 5.0), GraphTest.createEdge(db, "e6", "D", "E", 2.0), GraphTest.createEdge(db, "e7", "E", "F", 1.0), GraphTest.createEdge(db, "e8", "B", "F", 7.0));
        GraphTest.testPath(db, "A", "F", Arrays.asList("A", "D", "E", "F"), 4.0);
        GraphTest.testMultiplePaths(db, "A", "C", Arrays.asList(Arrays.asList("A", "B", "C"), Arrays.asList("A", "D", "C")), 5.0);
        edges.get(5).updateWeight(1.0, db);
        GraphTest.testPath(db, "A", "F", Arrays.asList("A", "D", "E", "F"), 3.0);
        GraphTest.testPath(db, "A", "G", Collections.emptyList(), Double.POSITIVE_INFINITY);
        AttributeEdge loopEdge = GraphTest.createEdge(db, "e9", "A", "A", 2.0);
        GraphTest.testPath(db, "A", "A", Collections.singletonList("A"), 0.0);
        GraphTest.testPath(db, "G", "A", Collections.emptyList(), Double.POSITIVE_INFINITY);
    }

    private static AttributeEdge createEdge(GraphDB db, String id, String from, String to, double weight) {
        AttributeEdge edge = new AttributeEdge(id, from, to, weight);
        db.addRelationship(edge);
        return edge;
    }

    private static void testPath(GraphDB db, String start, String end, List<String> expectedPath, double expectedCost) {
        boolean costValid;
        List<String> path = db.shortestPathWithWeights(start, end);
        double actualCost = GraphTest.calculatePathCost(db, path);
        System.out.println("\n=== \u6d4b\u8bd5\u8def\u5f84 " + start + " \u2192 " + end + " ===");
        System.out.println("\u9884\u671f\u8def\u5f84: " + expectedPath + " (\u6210\u672c: " + expectedCost + ")");
        System.out.println("\u5b9e\u9645\u8def\u5f84: " + path + " (\u6210\u672c: " + actualCost + ")");
        boolean pathValid = path.equals(expectedPath);
        boolean bl = costValid = Math.abs(actualCost - expectedCost) < 1.0E-4;
        if (pathValid && costValid) {
            System.out.println("\u221a\u221a\u221a \u6d4b\u8bd5\u901a\u8fc7");
        } else {
            System.out.println("\u00d7\u00d7\u00d7 \u6d4b\u8bd5\u5931\u8d25\uff01");
        }
    }

    private static void testMultiplePaths(GraphDB db, String start, String end, List<List<String>> possiblePaths, double expectedCost) {
        boolean costValid;
        List<String> path = db.shortestPathWithWeights(start, end);
        double actualCost = GraphTest.calculatePathCost(db, path);
        System.out.println("\n=== \u6d4b\u8bd5\u591a\u8def\u5f84 " + start + " \u2192 " + end + " ===");
        System.out.println("\u53ef\u80fd\u8def\u5f84: " + possiblePaths);
        System.out.println("\u5b9e\u9645\u8def\u5f84: " + path + " (\u6210\u672c: " + actualCost + ")");
        boolean pathValid = possiblePaths.contains(path);
        boolean bl = costValid = Math.abs(actualCost - expectedCost) < 0.001;
        if (pathValid && costValid) {
            System.out.println("\u221a\u221a\u221a \u6d4b\u8bd5\u901a\u8fc7");
        } else {
            System.out.println("\u00d7\u00d7\u00d7 \u6d4b\u8bd5\u5931\u8d25\uff01");
        }
    }

    private static double calculatePathCost(GraphDB db, List<String> path) {
        if (path.isEmpty()) {
            return Double.POSITIVE_INFINITY;
        }
        double total = 0.0;
        for (int i = 0; i < path.size() - 1; ++i) {
            String from = path.get(i);
            String to = path.get(i + 1);
            total += db.getNode(from).getOutgoingEdges().stream().filter(e -> e.getEndNodeId().equals(to)).findFirst().map(e -> ((Number)e.getProperties().getOrDefault("weight", 1.0)).doubleValue()).orElse(Double.POSITIVE_INFINITY).doubleValue();
        }
        return total;
    }
}

