/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.knn;

import io.github.javpower.vectorex.keynote.knn.DistanceFunction;
import io.github.javpower.vectorex.keynote.knn.SparseVector;

public final class DistanceFunctions {
    public static final DistanceFunction<float[], Float> FLOAT_COSINE_DISTANCE = new FloatCosineDistance();
    public static final DistanceFunction<float[], Float> FLOAT_INNER_PRODUCT = new FloatInnerProduct();
    public static final DistanceFunction<float[], Float> FLOAT_EUCLIDEAN_DISTANCE = new FloatEuclideanDistance();
    public static final DistanceFunction<float[], Float> FLOAT_CANBERRA_DISTANCE = new FloatCanberraDistance();
    public static final DistanceFunction<float[], Float> FLOAT_BRAY_CURTIS_DISTANCE = new FloatBrayCurtisDistance();
    public static final DistanceFunction<float[], Float> FLOAT_CORRELATION_DISTANCE = new FloatCorrelationDistance();
    public static final DistanceFunction<float[], Float> FLOAT_MANHATTAN_DISTANCE = new FloatManhattanDistance();
    public static final DistanceFunction<double[], Double> DOUBLE_COSINE_DISTANCE = new DoubleCosineDistance();
    public static final DistanceFunction<double[], Double> DOUBLE_INNER_PRODUCT = new DoubleInnerProduct();
    public static final DistanceFunction<double[], Double> DOUBLE_EUCLIDEAN_DISTANCE = new DoubleEuclideanDistance();
    public static final DistanceFunction<double[], Double> DOUBLE_CANBERRA_DISTANCE = new DoubleCanberraDistance();
    public static final DistanceFunction<double[], Double> DOUBLE_BRAY_CURTIS_DISTANCE = new DoubleBrayCurtisDistance();
    public static final DistanceFunction<double[], Double> DOUBLE_CORRELATION_DISTANCE = new DoubleCorrelationDistance();
    public static final DistanceFunction<double[], Double> DOUBLE_MANHATTAN_DISTANCE = new DoubleManhattanDistance();
    public static final DistanceFunction<SparseVector<float[]>, Float> FLOAT_SPARSE_VECTOR_INNER_PRODUCT = new FloatSparseVectorInnerProduct();
    public static final DistanceFunction<SparseVector<double[]>, Double> DOUBLE_SPARSE_VECTOR_INNER_PRODUCT = new DoubleSparseVectorInnerProduct();

    private DistanceFunctions() {
    }

    static class DoubleManhattanDistance
    implements DistanceFunction<double[], Double> {
        private static final long serialVersionUID = 1L;

        DoubleManhattanDistance() {
        }

        @Override
        public Double distance(double[] u, double[] v) {
            double sum = 0.0;
            for (int i = 0; i < u.length; ++i) {
                sum += Math.abs(u[i] - v[i]);
            }
            return sum;
        }
    }

    static class DoubleCorrelationDistance
    implements DistanceFunction<double[], Double> {
        private static final long serialVersionUID = 1L;

        DoubleCorrelationDistance() {
        }

        @Override
        public Double distance(double[] u, double[] v) {
            double x = 0.0;
            double y = 0.0;
            for (int i = 0; i < u.length; ++i) {
                x += -u[i];
                y += -v[i];
            }
            x /= (double)u.length;
            y /= (double)v.length;
            double num = 0.0;
            double den1 = 0.0;
            double den2 = 0.0;
            for (int i = 0; i < u.length; ++i) {
                num += (u[i] + x) * (v[i] + y);
                den1 += Math.abs(Math.pow(u[i] + x, 2.0));
                den2 += Math.abs(Math.pow(v[i] + x, 2.0));
            }
            return 1.0 - num / (Math.sqrt(den1) * Math.sqrt(den2));
        }
    }

    static class DoubleBrayCurtisDistance
    implements DistanceFunction<double[], Double> {
        private static final long serialVersionUID = 1L;

        DoubleBrayCurtisDistance() {
        }

        @Override
        public Double distance(double[] u, double[] v) {
            double sump = 0.0;
            double sumn = 0.0;
            for (int i = 0; i < u.length; ++i) {
                sumn += Math.abs(u[i] - v[i]);
                sump += Math.abs(u[i] + v[i]);
            }
            return sumn / sump;
        }
    }

    static class DoubleCanberraDistance
    implements DistanceFunction<double[], Double> {
        private static final long serialVersionUID = 1L;

        DoubleCanberraDistance() {
        }

        @Override
        public Double distance(double[] u, double[] v) {
            double sum = 0.0;
            for (int i = 0; i < u.length; ++i) {
                double num = Math.abs(u[i] - v[i]);
                double denom = Math.abs(u[i]) + Math.abs(v[i]);
                sum += num == 0.0 && denom == 0.0 ? 0.0 : num / denom;
            }
            return sum;
        }
    }

    static class DoubleEuclideanDistance
    implements DistanceFunction<double[], Double> {
        private static final long serialVersionUID = 1L;

        DoubleEuclideanDistance() {
        }

        @Override
        public Double distance(double[] u, double[] v) {
            double sum = 0.0;
            for (int i = 0; i < u.length; ++i) {
                double dp = u[i] - v[i];
                sum += dp * dp;
            }
            return Math.sqrt(sum);
        }
    }

    static class DoubleInnerProduct
    implements DistanceFunction<double[], Double> {
        private static final long serialVersionUID = 1L;

        DoubleInnerProduct() {
        }

        @Override
        public Double distance(double[] u, double[] v) {
            double dot = 0.0;
            for (int i = 0; i < u.length; ++i) {
                dot += u[i] * v[i];
            }
            return 1.0 - dot;
        }
    }

    static class DoubleCosineDistance
    implements DistanceFunction<double[], Double> {
        private static final long serialVersionUID = 1L;

        DoubleCosineDistance() {
        }

        @Override
        public Double distance(double[] u, double[] v) {
            double dot = 0.0;
            double nru = 0.0;
            double nrv = 0.0;
            for (int i = 0; i < u.length; ++i) {
                dot += u[i] * v[i];
                nru += u[i] * u[i];
                nrv += v[i] * v[i];
            }
            double similarity = dot / (Math.sqrt(nru) * Math.sqrt(nrv));
            return 1.0 - similarity;
        }
    }

    static class FloatManhattanDistance
    implements DistanceFunction<float[], Float> {
        private static final long serialVersionUID = 1L;

        FloatManhattanDistance() {
        }

        @Override
        public Float distance(float[] u, float[] v) {
            float sum = 0.0f;
            for (int i = 0; i < u.length; ++i) {
                sum += Math.abs(u[i] - v[i]);
            }
            return Float.valueOf(sum);
        }
    }

    static class FloatCorrelationDistance
    implements DistanceFunction<float[], Float> {
        private static final long serialVersionUID = 1L;

        FloatCorrelationDistance() {
        }

        @Override
        public Float distance(float[] u, float[] v) {
            float x = 0.0f;
            float y = 0.0f;
            for (int i = 0; i < u.length; ++i) {
                x += -u[i];
                y += -v[i];
            }
            x /= (float)u.length;
            y /= (float)v.length;
            float num = 0.0f;
            float den1 = 0.0f;
            float den2 = 0.0f;
            for (int i = 0; i < u.length; ++i) {
                num += (u[i] + x) * (v[i] + y);
                den1 += (float)Math.abs(Math.pow(u[i] + x, 2.0));
                den2 += (float)Math.abs(Math.pow(v[i] + x, 2.0));
            }
            return Float.valueOf(1.0f - num / ((float)Math.sqrt(den1) * (float)Math.sqrt(den2)));
        }
    }

    static class FloatBrayCurtisDistance
    implements DistanceFunction<float[], Float> {
        private static final long serialVersionUID = 1L;

        FloatBrayCurtisDistance() {
        }

        @Override
        public Float distance(float[] u, float[] v) {
            float sump = 0.0f;
            float sumn = 0.0f;
            for (int i = 0; i < u.length; ++i) {
                sumn += Math.abs(u[i] - v[i]);
                sump += Math.abs(u[i] + v[i]);
            }
            return Float.valueOf(sumn / sump);
        }
    }

    static class FloatCanberraDistance
    implements DistanceFunction<float[], Float> {
        private static final long serialVersionUID = 1L;

        FloatCanberraDistance() {
        }

        @Override
        public Float distance(float[] u, float[] v) {
            float sum = 0.0f;
            for (int i = 0; i < u.length; ++i) {
                float num = Math.abs(u[i] - v[i]);
                float denominator = Math.abs(u[i]) + Math.abs(v[i]);
                sum += (double)num == 0.0 && (double)denominator == 0.0 ? 0.0f : num / denominator;
            }
            return Float.valueOf(sum);
        }
    }

    static class FloatEuclideanDistance
    implements DistanceFunction<float[], Float> {
        private static final long serialVersionUID = 1L;

        FloatEuclideanDistance() {
        }

        @Override
        public Float distance(float[] u, float[] v) {
            float sum = 0.0f;
            for (int i = 0; i < u.length; ++i) {
                float dp = u[i] - v[i];
                sum += dp * dp;
            }
            return Float.valueOf((float)Math.sqrt(sum));
        }
    }

    static class FloatInnerProduct
    implements DistanceFunction<float[], Float> {
        private static final long serialVersionUID = 1L;

        FloatInnerProduct() {
        }

        @Override
        public Float distance(float[] u, float[] v) {
            float dot = 0.0f;
            for (int i = 0; i < u.length; ++i) {
                dot += u[i] * v[i];
            }
            return Float.valueOf(1.0f - dot);
        }
    }

    static class FloatCosineDistance
    implements DistanceFunction<float[], Float> {
        private static final long serialVersionUID = 1L;

        FloatCosineDistance() {
        }

        @Override
        public Float distance(float[] u, float[] v) {
            float dot = 0.0f;
            float nru = 0.0f;
            float nrv = 0.0f;
            for (int i = 0; i < u.length; ++i) {
                dot += u[i] * v[i];
                nru += u[i] * u[i];
                nrv += v[i] * v[i];
            }
            float similarity = dot / (float)(Math.sqrt(nru) * Math.sqrt(nrv));
            return Float.valueOf(1.0f - similarity);
        }
    }

    static class DoubleSparseVectorInnerProduct
    implements DistanceFunction<SparseVector<double[]>, Double> {
        DoubleSparseVectorInnerProduct() {
        }

        @Override
        public Double distance(SparseVector<double[]> u, SparseVector<double[]> v) {
            int[] uIndices = u.indices();
            double[] uValues = u.values();
            int[] vIndices = v.indices();
            double[] vValues = v.values();
            double dot = 0.0;
            int i = 0;
            int j = 0;
            while (i < uIndices.length && j < vIndices.length) {
                if (uIndices[i] < vIndices[j]) {
                    ++i;
                    continue;
                }
                if (uIndices[i] > vIndices[j]) {
                    ++j;
                    continue;
                }
                dot += uValues[i] * vValues[j];
                ++i;
                ++j;
            }
            return 1.0 - dot;
        }
    }

    static class FloatSparseVectorInnerProduct
    implements DistanceFunction<SparseVector<float[]>, Float> {
        FloatSparseVectorInnerProduct() {
        }

        @Override
        public Float distance(SparseVector<float[]> u, SparseVector<float[]> v) {
            int[] uIndices = u.indices();
            float[] uValues = u.values();
            int[] vIndices = v.indices();
            float[] vValues = v.values();
            float dot = 0.0f;
            int i = 0;
            int j = 0;
            while (i < uIndices.length && j < vIndices.length) {
                if (uIndices[i] < vIndices[j]) {
                    ++i;
                    continue;
                }
                if (uIndices[i] > vIndices[j]) {
                    ++j;
                    continue;
                }
                dot += uValues[i] * vValues[j];
                ++i;
                ++j;
            }
            return Float.valueOf(1.0f - dot);
        }
    }
}

