/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.knn;

import io.github.javpower.vectorex.keynote.knn.Item;
import io.github.javpower.vectorex.keynote.knn.NullProgressListener;
import io.github.javpower.vectorex.keynote.knn.ProgressListener;
import io.github.javpower.vectorex.keynote.knn.SearchResult;
import io.github.javpower.vectorex.keynote.knn.UncategorizedIndexException;
import io.github.javpower.vectorex.keynote.knn.util.NamedThreadFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public interface Index<TId, TVector, TItem extends Item<TId, TVector>, TDistance>
extends Serializable {
    public static final int DEFAULT_PROGRESS_UPDATE_INTERVAL = 100000;

    public boolean add(TItem var1);

    public boolean remove(TId var1, long var2);

    default public boolean contains(TId id) {
        return this.get(id).isPresent();
    }

    default public void addAll(Collection<TItem> items) throws InterruptedException {
        this.addAll(items, NullProgressListener.INSTANCE);
    }

    default public void addAll(Collection<TItem> items, ProgressListener listener) throws InterruptedException {
        this.addAll(items, Runtime.getRuntime().availableProcessors(), listener, 100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public void addAll(Collection<TItem> items, int numThreads, ProgressListener listener, int progressUpdateInterval) throws InterruptedException {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(numThreads, numThreads, 60L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("indexer-%d"));
        executorService.allowCoreThreadTimeOut(true);
        int numItems = items.size();
        AtomicInteger workDone = new AtomicInteger();
        try {
            LinkedBlockingQueue<TItem> queue = new LinkedBlockingQueue<TItem>(items);
            ArrayList futures = new ArrayList();
            for (int threadId = 0; threadId < numThreads; ++threadId) {
                futures.add(executorService.submit(() -> {
                    Item item;
                    while ((item = (Item)queue.poll()) != null) {
                        this.add(item);
                        int done = workDone.incrementAndGet();
                        if (done % progressUpdateInterval != 0 && numItems != done) continue;
                        listener.updateProgress(done, items.size());
                    }
                }));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    throw new UncategorizedIndexException("An exception was thrown by one of the threads.", e.getCause());
                    return;
                }
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    public int size();

    public Optional<TItem> get(TId var1);

    public Collection<TItem> items();

    public List<SearchResult<TItem, TDistance>> findNearest(TVector var1, int var2);

    default public List<SearchResult<TItem, TDistance>> findNeighbors(TId id, int k) {
        return this.get(id).map(item -> this.findNearest(item.vector(), k + 1).stream().filter(result -> !((Item)result.item()).id().equals(id)).limit(k).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public void save(OutputStream var1) throws IOException;

    default public void save(File file) throws IOException {
        this.save(new FileOutputStream(file));
    }

    default public void save(Path path) throws IOException {
        this.save(Files.newOutputStream(path, new OpenOption[0]));
    }
}

