/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.knn.util;

import java.io.Serializable;
import java.util.Arrays;

public class ArrayBitSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int[] buffer;

    public ArrayBitSet(int count) {
        this.buffer = new int[(count >> 5) + 1];
    }

    public ArrayBitSet(ArrayBitSet other, int count) {
        this.buffer = Arrays.copyOf(other.buffer, (count >> 5) + 1);
    }

    public boolean contains(int bitIndex) {
        int carrier = this.buffer[bitIndex >> 5];
        return (1 << (bitIndex & 0x1F) & carrier) != 0;
    }

    public void add(int id) {
        int mask = 1 << (id & 0x1F);
        int n = id >> 5;
        this.buffer[n] = this.buffer[n] | mask;
    }

    public void remove(int id) {
        int mask = 1 << (id & 0x1F);
        int n = id >> 5;
        this.buffer[n] = this.buffer[n] & ~mask;
    }

    public void clear() {
        Arrays.fill(this.buffer, 0);
    }
}

