/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.storage;

import io.github.javpower.vectorex.keynote.core.DbData;
import io.github.javpower.vectorex.keynote.model.VectorFiled;
import io.github.javpower.vectorex.keynote.storage.MapDBStorage;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDBManager {
    private static final Logger logger = LoggerFactory.getLogger(MapDBManager.class);
    private DB db;
    private Map<String, MapDBStorage> maps = new ConcurrentHashMap<String, MapDBStorage>();

    public MapDBManager(String dbPath) {
        try {
            this.db = DBMaker.fileDB((String)dbPath).closeOnJvmShutdown().make();
            logger.info("MapDB initialized at: {}", (Object)dbPath);
        }
        catch (Exception e) {
            logger.error("Failed to initialize MapDB", (Throwable)e);
            throw new RuntimeException("Failed to initialize MapDB", e);
        }
    }

    public void createCollection(String name, int maxDataCount, List<VectorFiled> vectorFiled) {
        HTreeMap mapdd = this.db.hashMap(name).createOrOpen();
        MapDBStorage mapDBStorage = new MapDBStorage(this.db, (HTreeMap<String, DbData>)mapdd, maxDataCount, vectorFiled);
        this.maps.put(name, mapDBStorage);
    }

    public MapDBStorage getMap(String name) {
        return this.maps.computeIfAbsent(name, n -> this.maps.get(n));
    }

    public DB getDb() {
        return this.db;
    }

    public void close() {
        try {
            this.db.close();
            logger.info("MapDB closed");
        }
        catch (Exception e) {
            logger.error("Failed to close MapDB", (Throwable)e);
            throw new RuntimeException("Failed to close MapDB", e);
        }
    }

    public void delCollection(String collection) {
        this.maps.remove(collection);
    }
}

