/*
 * Decompiled with CFR 0.152.
 */
package io.github.javpower.vectorex.keynote.utils;

import io.github.javpower.vectorex.keynote.core.DbData;
import io.github.javpower.vectorex.keynote.core.VectorData;
import io.github.javpower.vectorex.keynote.core.VectorSearchResult;
import io.github.javpower.vectorex.keynote.storage.MapDBStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class VectorTest {
    private static void addEnglishData(MapDBStorage face) {
        HashMap<String, Object> metadata1 = new HashMap<String, Object>();
        metadata1.put("id", "1");
        metadata1.put("category", "animal");
        metadata1.put("size", "small");
        HashMap<String, Object> metadata2 = new HashMap<String, Object>();
        metadata2.put("id", "2");
        metadata2.put("category", "animal vv");
        metadata2.put("size", "large");
        VectorData data1 = new VectorData("1", new float[]{1.0f, 2.0f, 3.0f});
        data1.setName("vector");
        VectorData data2 = new VectorData("2", new float[]{4.0f, 5.0f, 6.0f});
        data2.setName("vector");
        DbData dbData1 = new DbData();
        dbData1.setId("1");
        dbData1.setMetadata(metadata1);
        DbData dbData2 = new DbData();
        dbData2.setId("2");
        dbData2.setMetadata(metadata2);
        face.save(dbData1);
        face.save(dbData2);
    }

    private static void addChineseData(MapDBStorage face) {
        HashMap<String, Object> metadata3 = new HashMap<String, Object>();
        metadata3.put("id", "3");
        metadata3.put("category", "\u52a8\u7269");
        metadata3.put("size", "\u5c0f");
        HashMap<String, Object> metadata4 = new HashMap<String, Object>();
        metadata4.put("id", "4");
        metadata4.put("category", "\u52a8\u7269 \u4e16\u754c");
        metadata4.put("size", "\u5927");
        VectorData data3 = new VectorData("3", new float[]{7.0f, 8.0f, 9.0f});
        data3.setName("vector");
        VectorData data4 = new VectorData("4", new float[]{10.0f, 11.0f, 12.0f});
        data4.setName("vector");
        DbData dbData3 = new DbData();
        dbData3.setId("3");
        dbData3.setMetadata(metadata3);
        DbData dbData4 = new DbData();
        dbData4.setId("4");
        dbData4.setMetadata(metadata4);
        face.save(dbData3);
        face.save(dbData4);
    }

    private static void searchAndPrintResults(MapDBStorage face, String field, String query, int topK) {
        List<VectorSearchResult> results = face.search(field, query, topK, null);
        if (results.isEmpty()) {
            System.out.println("\u672a\u627e\u5230\u5339\u914d\u7ed3\u679c\u3002");
        } else {
            for (VectorSearchResult result : results) {
                System.out.println("\u627e\u5230\u5339\u914d\u7ed3\u679c: ID = " + result.getId() + ", \u5f97\u5206 = " + result.getScore());
            }
        }
        System.out.println();
    }

    private static void performanceTest(MapDBStorage face, String field, String query, int iterations) {
        ArrayList<Long> timings = new ArrayList<Long>();
        for (int i = 0; i < iterations; ++i) {
            long startTime = System.nanoTime();
            face.search(field, query, 2, null);
            long endTime = System.nanoTime();
            timings.add(endTime - startTime);
        }
        System.out.println("\u6bcf\u6b21\u641c\u7d22\u8017\u65f6\uff08\u7eb3\u79d2\uff09\uff1a");
        System.out.println(timings.stream().map(String::valueOf).collect(Collectors.joining(",")));
        double averageTime = timings.stream().mapToLong(Long::longValue).average().orElse(0.0);
        System.out.println("\u5e73\u5747\u8017\u65f6\uff08\u7eb3\u79d2\uff09\uff1a" + averageTime);
    }
}

