/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.util;

import io.jbock.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class Eithers {
    private static final Set<Collector.Characteristics> CH_NOID = Set.of();

    public static <L, R> Collector<Either<? extends L, ? extends R>, ?, Either<L, List<R>>> firstFailure() {
        BiConsumer<FirstFailureAcc, Either> accumulator = (acc, either) -> either.ifLeftOrElse(acc::addLeft, acc::addRight);
        BinaryOperator combiner = (acc, other) -> (FirstFailureAcc)acc.combine(other);
        return new CollectorImpl<Either, FirstFailureAcc, Either>(() -> new FirstFailureAcc(), accumulator, combiner, Acc::finish);
    }

    public static <L, R> Collector<Either<? extends L, ? extends R>, ?, Either<List<L>, List<R>>> allFailures() {
        BiConsumer<AllFailuresAcc, Either> accumulator = (acc, either) -> either.ifLeftOrElse(acc::addLeft, acc::addRight);
        BinaryOperator combiner = (acc, other) -> (AllFailuresAcc)acc.combine(other);
        return new CollectorImpl<Either, AllFailuresAcc, Either>(() -> new AllFailuresAcc(), accumulator, combiner, Acc::finish);
    }

    public static <T> Collector<T, ?, Optional<List<T>>> toOptionalList() {
        return Collectors.collectingAndThen(Collectors.toList(), Eithers::optionalList);
    }

    public static <T> Optional<List<T>> optionalList(List<? extends T> values) {
        if (values.isEmpty()) {
            return Optional.empty();
        }
        List<T> result = values;
        return Optional.of(result);
    }

    private Eithers() {
    }

    private static final class CollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        final Supplier<A> supplier;
        final BiConsumer<A, T> accumulator;
        final BinaryOperator<A> combiner;
        final Function<A, R> finisher;

        CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return CH_NOID;
        }
    }

    private static final class AllFailuresAcc<L, R>
    extends Acc<L, List<L>, R> {
        List<L> left;

        private AllFailuresAcc() {
        }

        @Override
        void combineLeft(List<L> otherLeft) {
            if (this.left == null) {
                this.left = otherLeft;
            } else if (otherLeft != null) {
                this.left.addAll(otherLeft);
            }
        }

        @Override
        void addLeft(L value) {
            if (this.left == null) {
                this.left = new ArrayList<L>();
            }
            this.left.add(value);
        }

        @Override
        List<L> leftColl() {
            return this.left;
        }
    }

    static abstract class Acc<L, C, R> {
        private ArrayList<R> right;

        Acc() {
        }

        abstract void combineLeft(C var1);

        abstract C leftColl();

        abstract void addLeft(L var1);

        final void addRight(R value) {
            if (this.leftColl() != null) {
                return;
            }
            if (this.right == null) {
                this.right = new ArrayList();
            }
            this.right.add(value);
        }

        final Acc<L, C, R> combine(Acc<L, C, R> other) {
            if (this.leftColl() != null) {
                this.combineLeft(other.leftColl());
                return this;
            }
            if (other.leftColl() != null) {
                return other;
            }
            if (other.right == null) {
                return this;
            }
            if (this.right == null) {
                this.right = other.right;
            } else {
                this.right.addAll(other.right);
            }
            return this;
        }

        final Either<C, List<R>> finish() {
            C left = this.leftColl();
            return left != null ? Either.left(left) : Either.right(this.right == null ? List.of() : this.right);
        }
    }

    private static final class FirstFailureAcc<L, R>
    extends Acc<L, L, R> {
        L left;

        private FirstFailureAcc() {
        }

        @Override
        void combineLeft(L otherLeft) {
            this.addLeft(otherLeft);
        }

        @Override
        void addLeft(L value) {
            if (this.left == null) {
                this.left = value;
            }
        }

        @Override
        L leftColl() {
            return this.left;
        }
    }
}

