/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.util;

import io.jbock.util.Either;
import io.jbock.util.Right;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

final class Left<L, R>
extends Either<L, R> {
    private final L value;

    Left(L value) {
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public Optional<L> getLeft() {
        return Optional.of(this.value);
    }

    @Override
    public boolean isLeft() {
        return true;
    }

    @Override
    public Optional<R> getRight() {
        return Optional.empty();
    }

    @Override
    public <R2> Either<L, R2> map(Function<? super R, ? extends R2> mapper) {
        Left result = this;
        return result;
    }

    @Override
    public <R2> Either<L, R2> flatMap(Function<? super R, ? extends Either<? extends L, ? extends R2>> mapper) {
        Left result = this;
        return result;
    }

    @Override
    public Either<L, R> filter(Function<? super R, Optional<? extends L>> predicate) {
        return this;
    }

    @Override
    public <L2> Either<L2, R> mapLeft(Function<? super L, ? extends L2> mapper) {
        return new Left<L2, R>(mapper.apply(this.value));
    }

    @Override
    public <L2> Either<L2, R> flatMapLeft(Function<? super L, ? extends Either<? extends L2, ? extends R>> mapper) {
        Either<? extends L2, ? extends R> result = mapper.apply(this.value);
        return result;
    }

    @Override
    public Either<L, R> filterLeft(Function<? super L, Optional<? extends R>> predicate) {
        Optional<R> test = predicate.apply(this.value);
        if (test.isEmpty()) {
            return this;
        }
        return new Right(test.orElseThrow());
    }

    @Override
    public <U> U fold(Function<? super L, ? extends U> leftMapper, Function<? super R, ? extends U> rightMapper) {
        return leftMapper.apply(this.value);
    }

    @Override
    public void ifLeftOrElse(Consumer<? super L> leftAction, Consumer<? super R> rightAction) {
        leftAction.accept(this.value);
    }

    @Override
    public <X extends Throwable> R orElseThrow(Function<? super L, ? extends X> exceptionSupplier) throws X {
        throw (Throwable)exceptionSupplier.apply(this.value);
    }

    @Override
    public String toString() {
        return String.format("Left[%s]", this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Left)) {
            return false;
        }
        Left other = (Left)obj;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return 31 * this.value.hashCode();
    }
}

