/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.util;

import io.jbock.util.Either;
import io.jbock.util.ValidatingCollector;
import io.jbock.util.ValidatingCollectorAll;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class Eithers {
    private Eithers() {
    }

    public static <L, R> Collector<Either<? extends L, ? extends R>, ?, Either<L, List<R>>> toValidList() {
        return new ValidatingCollector();
    }

    public static <L, R> Collector<Either<? extends L, ? extends R>, ?, Either<List<L>, List<R>>> toValidListAll() {
        return new ValidatingCollectorAll();
    }

    public static <T> Collector<T, ?, Optional<List<T>>> toOptionalList() {
        return Collectors.collectingAndThen(Collectors.toList(), Eithers::optionalList);
    }

    public static <T> Optional<List<T>> optionalList(List<? extends T> values) {
        if (values.isEmpty()) {
            return Optional.empty();
        }
        List<T> result = values;
        return Optional.of(result);
    }
}

