/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.annotated;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import net.jbock.annotated.AnnotatedOption;
import net.jbock.annotated.AnnotatedParameter;
import net.jbock.annotated.AnnotatedParameters;
import net.jbock.annotated.Executable;
import net.jbock.common.EnumName;
import net.jbock.common.ValidationFailure;

public abstract class AnnotatedMethod {
    private final EnumName enumName;
    private final String paramLabel;

    AnnotatedMethod(EnumName enumName, String paramLabel) {
        this.enumName = enumName;
        this.paramLabel = paramLabel;
    }

    abstract Executable executable();

    public abstract boolean isParameter();

    public abstract boolean isParameters();

    abstract Stream<AnnotatedOption> asAnnotatedOption();

    abstract Stream<AnnotatedParameter> asAnnotatedParameter();

    abstract Stream<AnnotatedParameters> asAnnotatedParameters();

    public final EnumName enumName() {
        return this.enumName;
    }

    public final String methodName() {
        return this.method().getSimpleName().toString();
    }

    public final TypeMirror returnType() {
        return this.method().getReturnType();
    }

    public final String paramLabel() {
        return this.paramLabel;
    }

    public final List<Modifier> accessModifiers() {
        return this.executable().accessModifiers();
    }

    public final Optional<TypeElement> converter() {
        return this.executable().converter();
    }

    public final ValidationFailure fail(String message) {
        return this.executable().fail(message);
    }

    public final ExecutableElement method() {
        return this.executable().method();
    }

    public final Optional<String> descriptionKey() {
        return this.executable().descriptionKey();
    }

    public final List<String> description() {
        return this.executable().description();
    }
}

