/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.annotated;

import io.jbock.util.Either;
import io.jbock.util.Eithers;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import net.jbock.annotated.AnnotatedMethod;
import net.jbock.annotated.AnnotatedMethods;
import net.jbock.annotated.AnnotatedMethodsBuilder;
import net.jbock.annotated.Executable;
import net.jbock.annotated.ExecutableElementsFinder;
import net.jbock.common.Annotations;
import net.jbock.common.EnumName;
import net.jbock.common.TypeTool;
import net.jbock.common.Util;
import net.jbock.common.ValidationFailure;
import net.jbock.javax.inject.Inject;
import net.jbock.processor.SourceElement;
import net.jbock.validate.ValidateScope;

@ValidateScope
public class AnnotatedMethodsFactory {
    private final Util util;
    private final SourceElement sourceElement;
    private final ExecutableElementsFinder executableElementsFinder;

    @Inject
    AnnotatedMethodsFactory(Util util, SourceElement sourceElement, ExecutableElementsFinder executableElementsFinder) {
        this.util = util;
        this.sourceElement = sourceElement;
        this.executableElementsFinder = executableElementsFinder;
    }

    public Either<List<ValidationFailure>, AnnotatedMethods> createAnnotatedMethods() {
        return this.executableElementsFinder.findExecutableElements().flatMap(this::createAnnotatedMethods).map(AnnotatedMethodsBuilder.Step3::withNamedOptions).map(AnnotatedMethodsBuilder.Step4::withPositionalParameters).map(AnnotatedMethodsBuilder.Step5::withRepeatablePositionalParameters).flatMap(AnnotatedMethodsBuilder::build);
    }

    private Either<List<ValidationFailure>, AnnotatedMethodsBuilder.Step3> createAnnotatedMethods(AnnotatedMethodsBuilder.Step2 step) {
        Map<Name, EnumName> enumNames = step.enumNames();
        return ((Either)step.methods().stream().map(sourceMethod -> this.createAnnotatedMethod((Executable)sourceMethod, (EnumName)enumNames.get(sourceMethod.simpleName()))).collect(Eithers.toValidListAll())).map(step::withAnnotatedMethods);
    }

    private Either<ValidationFailure, AnnotatedMethod> createAnnotatedMethod(Executable sourceMethod, EnumName enumName) {
        ExecutableElement method = sourceMethod.method();
        return this.util.checkNoDuplicateAnnotations(method, Annotations.methodLevelAnnotations()).map(Either::left).orElseGet(() -> Either.right((Object)sourceMethod.annotatedMethod(this.sourceElement, enumName))).filter(this::checkAccessibleReturnType);
    }

    private Optional<ValidationFailure> checkAccessibleReturnType(AnnotatedMethod annotatedMethod) {
        return TypeTool.AS_DECLARED.visit(annotatedMethod.returnType()).filter(this::isInaccessible).map(type -> annotatedMethod.fail("inaccessible type: " + this.util.typeToString((TypeMirror)type)));
    }

    private boolean isInaccessible(DeclaredType declared) {
        if (declared.asElement().getModifiers().contains((Object)Modifier.PRIVATE)) {
            return true;
        }
        if (TypeTool.AS_TYPE_ELEMENT.visit(declared.asElement()).filter(t -> t.getNestingKind() == NestingKind.MEMBER).filter(t -> !t.getModifiers().contains((Object)Modifier.STATIC)).isPresent()) {
            return true;
        }
        return declared.getTypeArguments().stream().map(TypeTool.AS_DECLARED::visit).flatMap(Optional::stream).anyMatch(this::isInaccessible);
    }
}

