/*
 * Decompiled with CFR 0.152.
 */
package net.jbock.annotated;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jbock.annotated.AnnotatedMethod;
import net.jbock.annotated.AnnotatedParameter;
import net.jbock.annotated.AnnotatedParameters;
import net.jbock.annotated.Executable;
import net.jbock.annotated.ExecutableOption;
import net.jbock.common.EnumName;
import net.jbock.common.SnakeName;

public final class AnnotatedOption
extends AnnotatedMethod {
    static final Comparator<String> UNIX_NAMES_FIRST_COMPARATOR = Comparator.comparing(String::length).thenComparing(String::toString);
    private final ExecutableOption option;
    private final List<String> names;

    private AnnotatedOption(EnumName enumName, ExecutableOption option, String paramLabel, List<String> names) {
        super(enumName, paramLabel);
        this.option = option;
        this.names = names;
    }

    static AnnotatedOption createOption(ExecutableOption option, EnumName enumName) {
        List<String> names = option.names().stream().sorted(UNIX_NAMES_FIRST_COMPARATOR).collect(Collectors.toList());
        String paramLabel = option.paramLabel().or(() -> names.stream().filter(name -> name.startsWith("--")).map(name -> name.substring(2)).map(s -> s.toUpperCase(Locale.US)).findFirst()).orElseGet(() -> SnakeName.create(option.simpleName().toString()).snake('_').toUpperCase(Locale.US));
        return new AnnotatedOption(enumName, option, paramLabel, names);
    }

    @Override
    Executable executable() {
        return this.option;
    }

    @Override
    public boolean isParameter() {
        return false;
    }

    @Override
    public boolean isParameters() {
        return false;
    }

    public List<String> names() {
        return this.names;
    }

    @Override
    Stream<AnnotatedOption> asAnnotatedOption() {
        return Stream.of(this);
    }

    @Override
    Stream<AnnotatedParameter> asAnnotatedParameter() {
        return Stream.empty();
    }

    @Override
    Stream<AnnotatedParameters> asAnnotatedParameters() {
        return Stream.empty();
    }
}

